/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.DynamicAny;

import java.util.Hashtable;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.DynamicAny.DynAnyFactory_impl;
import org.apache.yoko.orb.DynamicAny.DynAny_impl;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OCI.Buffer;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.TypeCode;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;

public final class DynValueReader {
    private ORBInstance orbInstance_;
    private DynAnyFactory factory_;
    private Hashtable instanceTable_;
    private boolean truncateOK_;
    public boolean mustTruncate;

    public DynValueReader(ORBInstance orbInstance, DynAnyFactory factory, boolean truncateOK) {
        this.orbInstance_ = orbInstance;
        this.factory_ = factory;
        this.truncateOK_ = truncateOK;
        this.mustTruncate = false;
        this.instanceTable_ = new Hashtable(131);
    }

    public DynAny readValue(InputStream in, TypeCode tc) throws InconsistentTypeCode {
        DynAny result = this.getValue(in, tc);
        if (result != null) {
            return result;
        }
        Buffer buf = in._OB_buffer();
        int save = buf.pos_;
        int tag = in.read_long();
        int curPos = save;
        try {
            if (tag == -1) {
                return this.readIndirection(in);
            }
        }
        catch (MARSHAL ex) {
            Assert._OB_assert(ex);
            return null;
        }
        DynAnyFactory_impl factory_impl = (DynAnyFactory_impl)this.factory_;
        result = factory_impl.prepare_dyn_any_from_type_code(tc, this);
        if (tag != 0) {
            int startPos = curPos;
            this.indexValue(startPos, result);
        }
        in._OB_pos(save);
        DynAny_impl impl = (DynAny_impl)result;
        impl._OB_unmarshal(in);
        return result;
    }

    protected void indexValue(int startPos, DynAny dv) {
        this.instanceTable_.put(new Integer(startPos), dv);
    }

    private DynAny readIndirection(InputStream in) throws MARSHAL {
        Buffer buf = in._OB_buffer();
        int offs = in.read_long();
        int startPos = buf.pos_ - 4 + offs;
        DynAny result = (DynAny)this.instanceTable_.get(new Integer(startPos));
        if (result == null) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974954), 1095974954, CompletionStatus.COMPLETED_NO);
        }
        return result;
    }

    private DynAny getValue(InputStream in, TypeCode tc) {
        Buffer buf = in._OB_buffer();
        int startPos = buf.pos_;
        DynAny orig = (DynAny)this.instanceTable_.get(new Integer(startPos));
        if (orig == null) {
            return null;
        }
        DynAnyFactory_impl factory_impl = (DynAnyFactory_impl)this.factory_;
        DynAny copy = null;
        try {
            copy = factory_impl.prepare_dyn_any_from_type_code(tc, this);
        }
        catch (InconsistentTypeCode ex) {
            Assert._OB_assert(ex);
        }
        DynAny_impl impl = (DynAny_impl)copy;
        impl._OB_unmarshal(in);
        return orig;
    }
}

