/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.webcontainer.srt.WriteBeyondContentLengthException;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.ResponseBuffer;
import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer
implements ResponseBuffer {
    private static final TraceComponent tc = Tr.register(BufferedWriter.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    protected Writer out;
    protected char[] buf = new char[0];
    protected int count;
    protected long total;
    protected long limit;
    protected IResponse response;
    protected long length = -1L;
    protected IOutputStreamObserver obs;
    protected boolean _hasWritten;
    protected boolean _hasFlushed;
    protected IOException except;
    protected boolean committed;
    private int bufferSize;
    private boolean closeOnClose = false;
    private static TraceNLS nls = TraceNLS.getTraceNLS(BufferedWriter.class, (String)"com.ibm.ws.webcontainer.resources.Messages");

    public BufferedWriter(int size) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BufferedWriter(), size --> " + size), (Object[])new Object[0]);
        }
        this.buf = new char[size];
        this.bufferSize = size;
        this._hasWritten = false;
        this._hasFlushed = false;
    }

    public BufferedWriter() {
        this(1024);
    }

    public void init(Writer out, int bufSize) {
        this.initNewBuffer(out, bufSize);
    }

    void initNewBuffer(Writer out, int bufSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initNewBuffer, size --> " + bufSize), (Object[])new Object[0]);
        }
        this.out = out;
        this.except = null;
        if (this.buf.length != bufSize) {
            this.bufferSize = bufSize;
            this.buf = new char[this.bufferSize];
        }
    }

    public void finish() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"finish", (Object[])new Object[0]);
        }
        if (this.length == -1L && this.total != 0L) {
            this.length = this.total;
        }
        if (WCCustomProperties.SET_CONTENT_LENGTH_ON_CLOSE && !this.committed) {
            if (!this._hasFlushed && this.obs != null) {
                if (!this.response.isCommitted()) {
                    this.setContentLengthHeader(this.length);
                }
                this._hasFlushed = true;
                this.obs.alertFirstFlush();
            }
            this.committed = true;
        }
        this.flush();
    }

    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"reset", (Object[])new Object[0]);
        }
        this.out = null;
        this.count = 0;
        this.total = 0L;
        this.limit = -1L;
        this.length = -1L;
        this.committed = false;
        this._hasWritten = false;
        this._hasFlushed = false;
        this.response = null;
    }

    public int getTotal() {
        if (this.total > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)this.total;
    }

    public long getTotalLong() {
        return this.total;
    }

    public void setObserver(IOutputStreamObserver obs) {
        this.obs = obs;
        this.limit = -1L;
    }

    @Override
    public boolean isCommitted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isCommitted: " + this.committed), (Object[])new Object[0]);
        }
        return this.committed;
    }

    protected void check() throws IOException {
        if (this.except != null) {
            this.flush();
            throw this.except;
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("write --> " + c), (Object[])new Object[0]);
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        if (this.limit > -1L && this.total >= this.limit) {
            throw new WriteBeyondContentLengthException();
        }
        if (this.count == this.buf.length) {
            this.response.setFlushMode(false);
            this.flushChars();
            this.response.setFlushMode(true);
        }
        this.buf[this.count++] = (char)c;
        ++this.total;
    }

    @Override
    public void write(@Sensitive char[] b, int off, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("write total: " + this.total + " len: " + len + " limit: " + this.limit + " buf.length: " + this.buf.length + " count: " + this.count), (Object[])new Object[0]);
        }
        if (len < 0) {
            if (tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"Illegal.Argument.Trying.to.write.chars", (Object[])new Object[0]);
            }
            throw new IllegalArgumentException();
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        if (this.limit > -1L && this.total + (long)len > this.limit) {
            len = (int)(this.limit - this.total);
            this.except = new WriteBeyondContentLengthException();
        }
        if (len >= this.buf.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"write, len >= buf.length", (Object[])new Object[0]);
            }
            this.response.setFlushMode(false);
            this.flushChars();
            this.total += (long)len;
            this.writeOut(b, off, len);
            this.response.setFlushMode(true);
            this.check();
            return;
        }
        int avail = this.buf.length - this.count;
        if (len > avail) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"write, len >= avail", (Object[])new Object[0]);
            }
            this.response.setFlushMode(false);
            this.flushChars();
            this.response.setFlushMode(true);
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
        this.total += (long)len;
        this.check();
    }

    @Override
    public void flush() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"flush", (Object[])new Object[0]);
        }
        this.flushChars();
    }

    protected void flushChars() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"flushChars", (Object[])new Object[0]);
        }
        if (!this.committed && !this._hasFlushed && this.obs != null) {
            this._hasFlushed = true;
            this.obs.alertFirstFlush();
        }
        this.committed = true;
        if (this.count > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("flushChars, Count = " + this.count), (Object[])new Object[0]);
            }
            this.writeOut(this.buf, 0, this.count);
            this.count = 0;
        } else if (this.response.getFlushMode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"flushChars, Count 0 still flush mode is true , forceful flush", (Object[])new Object[0]);
            }
            this.response.flushBufferedContent();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"flushChars, flush mode is false", (Object[])new Object[0]);
        }
    }

    public void print(String s) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("print --> " + s), (Object[])new Object[0]);
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        int len = s.length();
        if (this.limit > -1L && this.total + (long)len > this.limit) {
            len = (int)(this.limit - this.total);
            this.except = new WriteBeyondContentLengthException();
        }
        int off = 0;
        while (len > 0) {
            int n = this.buf.length - this.count;
            if (n == 0) {
                this.response.setFlushMode(false);
                this.flushChars();
                this.response.setFlushMode(true);
                n = this.buf.length - this.count;
            }
            if (n > len) {
                n = len;
            }
            s.getChars(off, off + n, this.buf, this.count);
            this.count += n;
            this.total += (long)n;
            off += n;
            len -= n;
        }
        this.check();
    }

    @Override
    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"close", (Object[])new Object[0]);
        }
        this.finish();
        try {
            this.obs.alertClose();
        }
        catch (Exception ex) {
            FFDCWrapper.processException(ex, "com.ibm.ws.webcontainer.srt.BufferedWriter.close", "397", this);
        }
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public void setLimitLong(long lim) {
        this.limit = lim;
    }

    public void setResponse(IResponse resp) {
        this.response = resp;
    }

    protected void writeOut(char[] buf, int offset, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeOut --> " + len), (Object[])new Object[0]);
        }
        try {
            this.out.write(buf, offset, len);
            this.out.flush();
        }
        catch (IOException ioe) {
            this.count = 0;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"IOException occurred in writeOut method, observer alerting close.", (Object[])new Object[]{ioe});
            }
            this.obs.alertClose();
            this.obs.alertException();
            throw ioe;
        }
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int size) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBufferSize --> " + size), (Object[])new Object[0]);
        }
        if (this.total > 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setBufferSize(): illegal state--> already wrote " + this.total + " bytes"), (Object[])new Object[0]);
            }
            throw new IllegalStateException(nls.getString("Cannot.set.buffer.size.after.data", "Can't set buffer size after data has been written to stream"));
        }
        this.initNewBuffer(this.out, size);
    }

    @Override
    public void clearBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"clearBuffer", (Object[])new Object[0]);
        }
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"clearBuffer(): illegal state--> stream is committed ", (Object[])new Object[0]);
            }
            throw new IllegalStateException();
        }
        this.total = 0L;
        this.count = 0;
        this._hasWritten = false;
    }

    @Override
    public void flushBuffer() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"flushBuffer", (Object[])new Object[0]);
        }
        this.flush();
    }

    private void setContentLengthHeader(long length) {
        this.response.setHeader("Content-Length", Long.toString(length));
    }
}

