/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.webapp;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.container.Container;
import com.ibm.ws.container.DeployedModule;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.VirtualHost;
import com.ibm.ws.webcontainer.core.BaseContainer;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebGroupConfiguration;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class WebGroup
extends BaseContainer {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.webapp");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.webapp.WebGroup";
    private static String sessUrlRewritePrefix = ";jsessionid=";
    private static final String qMark = "?";
    private WebGroupConfiguration config;
    protected WebApp webApp;

    public WebGroup(String name, Container parent) {
        super(name, parent);
    }

    public void initialize(WebGroupConfiguration c) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "initialize", "");
        }
        this.config = c;
        this.webApp = null;
    }

    public void removeContextAttribute(String string) {
    }

    public void setContextAttribute(String string, Object value) {
    }

    public WebGroupConfiguration getConfiguration() {
        return this.config;
    }

    public void addWebApplication(DeployedModule deployedModule, List extensionFactories) throws Throwable {
        WebAppConfiguration wConfig = deployedModule.getWebAppConfig();
        String displayName = wConfig.getDisplayName();
        logger.logp(Level.INFO, CLASS_NAME, "addWebApplication", "loading.web.module", displayName);
        WebApp webApp = deployedModule.getWebApp();
        try {
            this.webApp = webApp;
            webApp.initialize(wConfig, deployedModule, extensionFactories);
        }
        catch (Throwable th) {
            webApp.failed();
            webApp.destroy();
            this.webApp = null;
            FFDCFilter.processException((Throwable)th, (String)CLASS_NAME, (String)"131", (Object)this);
            Object[] arg = new Object[]{displayName};
            logger.logp(Level.SEVERE, CLASS_NAME, "addWebApplication", "Failed.to.initialize.webapp.{0}", arg);
            throw th;
        }
    }

    public String getMimeType(String withDot, String withoutDot) {
        return ((VirtualHost)this.parent).getMimeType(withDot, withoutDot);
    }

    public IHttpSessionContext getSessionContext(DeployedModule moduleConfig, WebApp webApp, ArrayList[] listeners) throws Throwable {
        return ((VirtualHost)this.parent).getSessionContext(moduleConfig, webApp, listeners);
    }

    public ServletContext findContext(String path) {
        return ((VirtualHost)this.parent).findContext(path);
    }

    public ServletContext getContext() {
        return this.webApp;
    }

    @Override
    public synchronized void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", "entry");
        }
        super.destroy();
        this.requestMapper = null;
        this.config = null;
        this.webApp = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "destroy");
        }
    }

    public synchronized void removeWebApplication(DeployedModule deployedModule) {
        if (this.webApp == null) {
            return;
        }
        this.destroy();
    }

    @Override
    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "WebGroup found --> " + this.getConfiguration().getContextRoot());
        }
        if (this.webApp == null) {
            throw new WebAppNotLoadedException(this.getConfiguration().getContextRoot());
        }
        this.webApp.handleRequest(req, res);
    }

    public static String stripURL(String url) {
        return WebGroup.stripURL(url, true);
    }

    public static String stripURL(String url, boolean checkQuestionMark) {
        int index2;
        int index1 = url.indexOf(sessUrlRewritePrefix);
        if (checkQuestionMark && (index2 = url.indexOf(qMark)) != -1) {
            if (index1 > index2) {
                throw new IllegalArgumentException("'jsessionid' Must occur before '?' in URL.");
            }
            url = url.substring(0, index2);
        }
        if (index1 != -1) {
            url = url.substring(0, index1);
        }
        return url;
    }

    public static String decodeUri(String url) {
        int index1 = url.indexOf(sessUrlRewritePrefix);
        int index2 = url.indexOf(qMark);
        String tmp = null;
        if (index2 != -1 && index2 > index1) {
            tmp = url.substring(index2);
        }
        if (index1 != -1) {
            url = url.substring(0, index1);
            if (tmp != null) {
                url = url + tmp;
            }
        }
        return url;
    }

    public ArrayList getWebApps() {
        ArrayList<WebApp> webApps = new ArrayList<WebApp>();
        webApps.add(this.webApp);
        return webApps;
    }

    public void notifyStart() {
        if (this.webApp != null) {
            this.webApp.notifyStart();
        }
    }

    static {
        if (WCCustomProperties.SESSION_REWRITE_IDENTIFIER != null) {
            sessUrlRewritePrefix = ";" + WCCustomProperties.SESSION_REWRITE_IDENTIFIER + "=";
        }
    }
}

