/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.servlet.TargetConfig;
import com.ibm.ws.webcontainer.util.ArrayEnumeration;
import com.ibm.ws.webcontainer.util.EmptyEnumeration;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.DeclareRoles;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;

public class ServletConfig
extends TargetConfig
implements IServletConfig {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.servlet");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.servlet.ServletConfig";
    protected static final TraceNLS nls = TraceNLS.getTraceNLS(ServletConfig.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    protected static final TraceNLS liberty_nls = TraceNLS.getTraceNLS(ServletConfig.class, (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private boolean enabled = true;
    private String servletName;
    private String className;
    private List<String> mappings;
    private Integer startUpWeight = null;
    private static final Integer DEFAULT_STARTUP = -1;
    private boolean isCachingEnabled = true;
    private boolean isStatisticsEnabled = true;
    private boolean isInternal = false;
    protected WebComponentMetaData metaData;
    private boolean singleThreadModelServlet;
    private boolean isJsp;
    private WebAppConfig webAppConfig;
    private IServletWrapper servletWrapper;
    private Class<? extends Servlet> servletClass;
    private Servlet servlet;
    private boolean addedToLoadOnStartup;
    private Integer previousWeight = null;
    private MultipartConfigElement multipartConfig = null;
    private File multipartConfigBaseLocation = null;
    private String runAsRole;
    private ServletSecurityElement servletSecurityElement;
    private DeclareRoles declareRolesAnnotation;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public ServletConfig(String id, WebAppConfig webAppConfig) {
        super(id);
        this.webAppConfig = webAppConfig;
    }

    @Override
    public void setAttributes(Map map) {
        this._attributes = map;
    }

    @Override
    public String getClassName() {
        if (this.className != null) {
            return this.className;
        }
        if (this.servletClass != null) {
            return this.servletClass.getName();
        }
        if (this.servlet != null) {
            return this.servlet.getClass().getName();
        }
        return null;
    }

    public String getServletName() {
        return this.servletName;
    }

    public Enumeration getInitParameterNames() {
        Map map = this.initParams;
        if (map != null && map.size() > 0) {
            return new ArrayEnumeration(map.keySet().toArray());
        }
        return EmptyEnumeration.instance();
    }

    @Override
    public boolean isLoadOnStartup() {
        return this.startUpWeight != null && this.startUpWeight.intValue() != DEFAULT_STARTUP.intValue();
    }

    @Override
    public int getStartUpWeight() {
        return this.startUpWeight == null ? DEFAULT_STARTUP.intValue() : this.startUpWeight.intValue();
    }

    @Override
    public void setStartUpWeight(Integer weight) {
        this.previousWeight = this.startUpWeight;
        this.startUpWeight = weight != null ? (weight >= 0 ? weight : DEFAULT_STARTUP) : DEFAULT_STARTUP;
        if (this.context != null) {
            this.context.addToStartWeightList(this);
        }
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void setServletName(String servletName) {
        this.setName(servletName);
        this.servletName = servletName;
    }

    @Override
    public void setMappings(List<String> list) {
        this.mappings = list;
    }

    @Override
    public List<String> getMappings() {
        if (this.mappings == null && (WCCustomProperties.EMPTY_SERVLET_MAPPINGS || WebContainer.getServletContainerSpecLevel() == 31)) {
            return new ArrayList<String>();
        }
        return this.mappings;
    }

    @Override
    public String toString() {
        StringWriter strWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(strWriter);
        Servlet servlet = this.getServlet();
        String servletObjectsClassName = null;
        if (servlet != null) {
            servletObjectsClassName = servlet.getClass().getName();
        }
        printWriter.println("Servlet->" + servletObjectsClassName);
        printWriter.println("\tgetClassName->" + this.getClassName());
        printWriter.println("\tgetName->" + this.getName());
        Collection mappings = this.getMappings();
        if (mappings != null) {
            for (String mapping : mappings) {
                printWriter.println("\tmapping->" + mapping);
            }
        } else {
            printWriter.println("\tno mappings\n");
        }
        printWriter.println("\tloadOnStartupWeight->" + this.getStartUpWeight());
        if (this.getRunAsRole() != null) {
            printWriter.println("\trunAsRole->" + this.getRunAsRole());
        }
        if (this.getServletSecurity() != null) {
            ServletSecurityElement servletSecurity = this.getServletSecurity();
            printWriter.println("\tServletSecurity->");
            Collection methodNames = servletSecurity.getMethodNames();
            if (methodNames != null && !methodNames.isEmpty()) {
                printWriter.print("\t\tMethodNames->");
                for (String methodName : methodNames) {
                    printWriter.print(methodName + ",");
                }
                printWriter.println();
            }
            this.writeHttpConstraintElementString(printWriter, (HttpConstraintElement)servletSecurity, "\t\t");
            Collection httpMethodConstraints = servletSecurity.getHttpMethodConstraints();
            if (httpMethodConstraints != null && httpMethodConstraints.size() > 0) {
                for (HttpMethodConstraintElement httpMethodConstraint : httpMethodConstraints) {
                    printWriter.println("\t\tHttpMethodConstraint:" + httpMethodConstraint.getMethodName());
                    this.writeHttpConstraintElementString(printWriter, (HttpConstraintElement)httpMethodConstraint, "\t\t\t");
                }
            }
        }
        printWriter.append("\t" + super.toString());
        printWriter.flush();
        return strWriter.toString();
    }

    private void writeHttpConstraintElementString(PrintWriter printWriter, HttpConstraintElement httpConstraintElement, String string) {
        ServletSecurity.TransportGuarantee transportGuarantee;
        printWriter.println(string + "EmptyRoleSemantic->" + httpConstraintElement.getEmptyRoleSemantic());
        String[] rolesAllowed = httpConstraintElement.getRolesAllowed();
        if (rolesAllowed != null && rolesAllowed.length > 0) {
            printWriter.print(string + "RolesAllowed->");
            for (String roleAllowed : rolesAllowed) {
                printWriter.print(roleAllowed + ",");
            }
            printWriter.println();
        }
        if ((transportGuarantee = httpConstraintElement.getTransportGuarantee()) != null) {
            printWriter.println(string + "transportGuarantee->" + transportGuarantee);
        }
    }

    @Override
    public boolean isCachingEnabled() {
        return this.isCachingEnabled;
    }

    @Override
    public void setIsCachingEnabled(boolean isEnabled) {
        this.isCachingEnabled = isEnabled;
    }

    @Override
    public boolean isInternal() {
        return this.isInternal;
    }

    @Override
    public void setInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    @Override
    public void setStatisticsEnabled(boolean value) {
        this.isStatisticsEnabled = value;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    @Override
    public void setMetaData(WebComponentMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public WebComponentMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public boolean isSingleThreadModelServlet() {
        return this.singleThreadModelServlet;
    }

    @Override
    public void setSingleThreadModelServlet(boolean singleThreadModelServlet) {
        this.singleThreadModelServlet = singleThreadModelServlet;
    }

    @Override
    public Set<String> addMapping(IServletConfig.CheckContextInitialized checkContextInitialized, String ... urlPatterns) {
        HashSet<String> mappingConflicts = null;
        if (checkContextInitialized == IServletConfig.CheckContextInitialized.TRUE && this.context.isInitialized()) {
            throw new IllegalStateException(liberty_nls.getString("Not.in.servletContextCreated"));
        }
        if (urlPatterns == null) {
            throw new IllegalArgumentException(nls.getString("add.servlet.mapping.to.null.url.patterns"));
        }
        if (urlPatterns.length == 0) {
            throw new IllegalArgumentException(nls.getString("add.servlet.mapping.to.empty.url.patterns"));
        }
        String path = null;
        for (String urlPattern : urlPatterns) {
            path = urlPattern;
            if (path.equals("/")) {
                path = "/*";
            }
            if (!this.context.containsTargetMapping(path)) continue;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addMapping", "found existing mapping for urlPattern->" + path);
            }
            if (mappingConflicts == null) {
                mappingConflicts = new HashSet<String>();
            }
            mappingConflicts.add(urlPattern);
        }
        if (mappingConflicts == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addMapping", "no mapping conflicts");
            }
            if (this.mappings == null) {
                this.mappings = new ArrayList<String>();
            }
            if (this.webAppConfig != null) {
                for (String urlPattern : urlPatterns) {
                    this.webAppConfig.addServletMapping(this.servletName, urlPattern);
                    try {
                        if (this.servletWrapper == null) continue;
                        if (urlPattern.equals("/")) {
                            urlPattern = "/*";
                        }
                        this.context.addMappingTarget(urlPattern, this.servletWrapper);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".addMapping"), (String)"423");
                    }
                }
            }
        }
        if (mappingConflicts == null) {
            mappingConflicts = Collections.EMPTY_SET;
        }
        return mappingConflicts;
    }

    public Set<String> addMapping(String ... urlPatterns) {
        return this.addMapping(IServletConfig.CheckContextInitialized.TRUE, urlPatterns);
    }

    @Override
    public boolean isJsp() {
        return this.isJsp;
    }

    @Override
    public void setIsJsp(boolean isJsp) {
        this.isJsp = isJsp;
    }

    @Override
    public IServletWrapper getServletWrapper() {
        return this.servletWrapper;
    }

    @Override
    public void setServletWrapper(IServletWrapper servletWrapper) {
        this.servletWrapper = servletWrapper;
    }

    @Override
    public void setServletClass(Class<? extends Servlet> servletClass) {
        this.servletClass = servletClass;
    }

    @Override
    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    @Override
    public Class<? extends Servlet> getServletClass() {
        return this.servletClass;
    }

    @Override
    public Servlet getServlet() {
        return this.servlet;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.setStartUpWeight(loadOnStartup);
    }

    @Override
    public boolean isAddedToLoadOnStartup() {
        return this.addedToLoadOnStartup;
    }

    @Override
    public void setAddedToLoadOnStartup(boolean addedToLoadOnStartup) {
        this.addedToLoadOnStartup = addedToLoadOnStartup;
    }

    @Override
    public boolean isWeightChanged() {
        return this.startUpWeight != this.previousWeight && !this.startUpWeight.equals(this.previousWeight);
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setMultipartConfig", "[location, maxFileSize, maxRequestSize, fileSizeThreshold],[" + multipartConfig.getLocation() + "," + multipartConfig.getMaxFileSize() + "," + multipartConfig.getMaxRequestSize() + "," + multipartConfig.getFileSizeThreshold());
        }
        this.multipartConfig = multipartConfig;
    }

    @Override
    public MultipartConfigElement getMultipartConfig() {
        return this.multipartConfig;
    }

    @Override
    public File getMultipartBaseLocation() {
        return this.multipartConfigBaseLocation;
    }

    @Override
    public void setMultipartBaseLocation(File arg0) {
        this.multipartConfigBaseLocation = arg0;
    }

    public void setRunAsRole(String runAsRole) {
        this.runAsRole = runAsRole;
    }

    public Set<String> setServletSecurity(ServletSecurityElement servletSecurityElement) {
        if (servletSecurityElement == null) {
            throw new IllegalArgumentException();
        }
        if (this.context.isInitialized()) {
            throw new IllegalStateException(liberty_nls.getString("Not.in.servletContextCreated"));
        }
        final WebApp webApp = ((WebAppConfiguration)this.webAppConfig).getWebApp();
        IWebAppSecurityCollaborator securityCollab = AccessController.doPrivileged(new PrivilegedAction<IWebAppSecurityCollaborator>(){

            @Override
            public IWebAppSecurityCollaborator run() {
                return webApp.getCollaboratorHelper().getSecurityCollaborator();
            }
        });
        String appName = webApp.getApplicationName();
        String contextRoot = this.webAppConfig.getContextRoot();
        String vHost = this.webAppConfig.getVirtualHostName();
        this.servletSecurityElement = servletSecurityElement;
        if (this.mappings != null) {
            List<String> listOfConflicts = securityCollab.getURIsInSecurityConstraints(appName, contextRoot, vHost, this.mappings);
            if (listOfConflicts != null) {
                HashSet<String> setOfConflicts = new HashSet<String>();
                setOfConflicts.addAll(listOfConflicts);
                return setOfConflicts;
            }
            return new HashSet<String>();
        }
        return new HashSet<String>();
    }

    public String getRunAsRole() {
        return this.runAsRole;
    }

    @Override
    public ServletSecurityElement getServletSecurity() {
        return this.servletSecurityElement;
    }

    @Override
    public boolean isClassDefined() {
        return this.getClassName() != null || this.getServletClass() != null || this.getServlet() != null;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

