/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.container.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.config.ServletConfigurator;
import com.ibm.ws.container.service.config.ServletConfiguratorHelper;
import com.ibm.ws.container.service.config.ServletConfiguratorHelperFactory;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.webcontainer.osgi.container.config.WebAppConfigurator;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.AdapterFactoryService;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ContainerAdapter.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "toType=com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration"})
public class WebAppConfigurationAdapter
implements ContainerAdapter<WebAppConfiguration> {
    private static final TraceComponent tc = Tr.register(WebAppConfigurationAdapter.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private final AtomicServiceReference<ResourceRefConfigFactory> resourceRefConfigFactorySRRef = new AtomicServiceReference("resourceRefConfigFactory");
    private final ConcurrentServiceReferenceSet<ServletConfiguratorHelperFactory> servletConfiguratorHelperFactories = new ConcurrentServiceReferenceSet("servletConfiguratorHelperFactory");

    public WebAppConfiguration adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        NonPersistentCache overlayCache = (NonPersistentCache)containerToAdapt.adapt(NonPersistentCache.class);
        WebModuleInfo moduleInfo = (WebModuleInfo)overlayCache.getFromCache(WebModuleInfo.class);
        if (moduleInfo == null) {
            throw new UnableToAdaptException("Container is not a Web Module");
        }
        WebAppConfigurator webAppConfigurator = new WebAppConfigurator(containerToAdapt, overlayCache, (ResourceRefConfigFactory)this.resourceRefConfigFactorySRRef.getService());
        for (ServletConfiguratorHelperFactory configHelperFactory : this.servletConfiguratorHelperFactories.services()) {
            ServletConfiguratorHelper configHelper = configHelperFactory.createConfiguratorHelper((ServletConfigurator)webAppConfigurator);
            webAppConfigurator.addHelper(configHelper);
        }
        webAppConfigurator.configure();
        WebAppConfiguration appConfig = (WebAppConfiguration)overlayCache.getFromCache(WebAppConfig.class);
        if (appConfig == null) {
            throw new UnableToAdaptException("WebAppConfiguration=null");
        }
        return appConfig;
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.resourceRefConfigFactorySRRef.activate(context);
        this.servletConfiguratorHelperFactories.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.resourceRefConfigFactorySRRef.deactivate(context);
        this.servletConfiguratorHelperFactories.deactivate(context);
    }

    @Reference(name="resourceRefConfigFactory", service=ResourceRefConfigFactory.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setResourceRefConfigFactory(ServiceReference<ResourceRefConfigFactory> ref) {
        this.resourceRefConfigFactorySRRef.setReference(ref);
    }

    protected void unsetResourceRefConfigFactory(ServiceReference<ResourceRefConfigFactory> ref) {
        this.resourceRefConfigFactorySRRef.unsetReference(ref);
    }

    @Reference(name="servletConfiguratorHelperFactory", service=ServletConfiguratorHelperFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setServletConfiguratorHelperFactory(ServiceReference<ServletConfiguratorHelperFactory> ref) {
        this.servletConfiguratorHelperFactories.addReference(ref);
    }

    protected void unsetServletConfiguratorHelperFactory(ServiceReference<ServletConfiguratorHelperFactory> ref) {
        this.servletConfiguratorHelperFactories.removeReference(ref);
    }

    @Reference(service=AdapterFactoryService.class, target="(&(containerToType=com.ibm.ws.container.service.annotations.WebAnnotations)(containerToType=com.ibm.ws.container.service.config.WebFragmentsInfo)(containerToType=com.ibm.ws.javaee.dd.web.WebApp)(containerToType=com.ibm.ws.javaee.dd.web.WebFragment)(containerToType=com.ibm.ws.javaee.dd.webbnd.WebBnd)(containerToType=com.ibm.ws.javaee.dd.webext.WebExt))")
    protected void setAdaptorFactoryService(AdapterFactoryService afs) {
    }

    protected void unsetAdaptorFactoryService(AdapterFactoryService afs) {
    }
}

