/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.http;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.http.HttpSessionContextImpl;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.ISession;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

public class HttpSessionImpl
implements HttpSession {
    private static final String methodClassName = "HttpSessionImpl";
    private static boolean _loggedVersion = false;
    private ISession _iSession;
    private ServletContext _servletContext;
    private static final HttpSessionContext _httpSessionContext = new HttpSessionContextImpl();

    protected HttpSessionImpl(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE) && !_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "", "CMVC Version 1.6 10/16/08 11:56:10");
            _loggedVersion = true;
        }
        this._iSession = session;
    }

    public long getCreationTime() {
        if (!this._iSession.isValid()) {
            throw new IllegalStateException();
        }
        return this._iSession.getCreationTime();
    }

    public String getId() {
        return this._iSession.getId();
    }

    public long getLastAccessedTime() {
        if (!this._iSession.isValid()) {
            throw new IllegalStateException();
        }
        return this._iSession.getLastAccessedTime();
    }

    public ServletContext setServletContext(ServletContext context) {
        this._servletContext = context;
        return this._servletContext;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this._iSession.setMaxInactiveInterval(maxInactiveInterval);
    }

    public int getMaxInactiveInterval() {
        return this._iSession.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return _httpSessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String attributeName) {
        ISession iSession = this._iSession;
        synchronized (iSession) {
            if (!this._iSession.isValid()) {
                throw new IllegalStateException("The following session is not valid! " + this._iSession.getId());
            }
            return this._iSession.getAttribute(attributeName);
        }
    }

    public Object getValue(String attributeName) {
        return this.getAttribute(attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        ISession iSession = this._iSession;
        synchronized (iSession) {
            if (!this._iSession.isValid()) {
                throw new IllegalStateException();
            }
            return this._iSession.getAttributeNames();
        }
    }

    public String[] getValueNames() {
        if (!this._iSession.isValid()) {
            throw new IllegalStateException();
        }
        Enumeration enumeration = this.getAttributeNames();
        Vector<String> valueNames = new Vector<String>();
        String name = null;
        while (enumeration.hasMoreElements()) {
            name = (String)enumeration.nextElement();
            valueNames.add(name);
        }
        String[] names = new String[valueNames.size()];
        return valueNames.toArray(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String attributeName, Object value) {
        ISession iSession = this._iSession;
        synchronized (iSession) {
            if (!this._iSession.isValid()) {
                throw new IllegalStateException();
            }
            if (null != value) {
                if (!(value instanceof HttpSessionBindingListener)) {
                    this._iSession.setAttribute(attributeName, value, Boolean.FALSE);
                } else {
                    this._iSession.setAttribute(attributeName, value, Boolean.TRUE);
                }
            }
        }
    }

    public void putValue(String attributeName, Object value) {
        this.setAttribute(attributeName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String attributeName) {
        ISession iSession = this._iSession;
        synchronized (iSession) {
            if (!this._iSession.isValid()) {
                throw new IllegalStateException();
            }
            Object object = this._iSession.removeAttribute(attributeName);
        }
    }

    public void removeValue(String attributeName) {
        this.removeAttribute(attributeName);
    }

    public void invalidate() {
        if (!this._iSession.isValid()) {
            throw new IllegalStateException();
        }
        this._iSession.invalidate();
    }

    public boolean isNew() {
        if (!this._iSession.isValid()) {
            throw new IllegalStateException();
        }
        return this._iSession.isNew();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("# HttpSessionImpl # \n { ").append("\n _iSession=").append(this._iSession).append("\n _httpSessionContext=").append(_httpSessionContext).append("\n } \n");
        return sb.toString();
    }

    public ISession getISession() {
        return this._iSession;
    }
}

