/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jndi.WSName;
import com.ibm.ws.jndi.internal.WSContext;
import com.ibm.ws.jndi.internal.literals.LiteralParser;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JNDIConsole
implements CommandProvider {
    private Context ctx;
    private Object last;
    static final long serialVersionUID = 6650688128722101864L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private Context getContext() throws NamingException {
        if (this.ctx == null) {
            this.ctx = new InitialContext();
        }
        return this.ctx;
    }

    private Object parseNextArgument(CommandInterpreter ci) {
        String arg = ci.nextArgument();
        return arg == null ? null : (arg.equals("$_") ? this.last : LiteralParser.parse(arg));
    }

    private void announce(CommandInterpreter ci, String op, String name) throws NamingException {
        ci.println((Object)("[" + this.getContext().getNameInNamespace() + "]." + op + "(\"" + name + "\")"));
    }

    private void announce(CommandInterpreter ci, String op, String name, Object obj) throws NamingException {
        String str = obj instanceof String ? "\"" + obj + '\"' : obj + " : " + obj.getClass();
        ci.println((Object)("[" + this.getContext().getNameInNamespace() + "]." + op + "(\"" + name + "\", " + str + ")"));
    }

    private void handleEx(CommandInterpreter ci, Exception e) {
        ci.println((Object)("\tfailed with exception: " + e.getClass()));
        ci.println((Object)("\t" + e.getMessage()));
        ci.printStackTrace((Throwable)e);
    }

    public void _jndilist(CommandInterpreter ci) {
        int i = 0;
        String arg = ci.nextArgument();
        while (arg != null) {
            this.list(ci, arg);
            arg = ci.nextArgument();
            ++i;
        }
        if (i == 0) {
            this.list(ci, "");
        }
    }

    @FFDCIgnore(value={Exception.class})
    private void list(CommandInterpreter ci, String name) {
        try {
            this.announce(ci, "listBindings", name);
            NamingEnumeration<Binding> bindings = name == null ? this.getContext().listBindings(WSName.EMPTY_NAME) : this.getContext().listBindings(name);
            TreeSet<String> subcontexts = new TreeSet<String>();
            TreeMap<String, Binding> noncontexts = new TreeMap<String, Binding>();
            while (bindings.hasMore()) {
                Binding b = bindings.next();
                if (b.getObject() instanceof WSContext) {
                    subcontexts.add(b.getName() + "/");
                    continue;
                }
                noncontexts.put(b.getName(), b);
            }
            for (String sc : subcontexts) {
                ci.println((Object)("\t" + sc));
            }
            for (Binding b : noncontexts.values()) {
                ci.println((Object)("\t" + b));
            }
        }
        catch (Exception e) {
            this.handleEx(ci, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void _jndilookup(CommandInterpreter ci) {
        try {
            String name = ci.nextArgument();
            this.announce(ci, "lookup", name);
            this.last = this.getContext().lookup(name);
            ci.println((Object)("\t" + (this.last instanceof WSContext ? name + "/" : this.last)));
        }
        catch (Exception name) {
            void e;
            FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.jndi.internal.JNDIConsole", (String)"104", (Object)this, (Object[])new Object[]{ci});
            this.handleEx(ci, (Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void _jndibind(CommandInterpreter ci) {
        try {
            String name = ci.nextArgument();
            Object obj = this.parseNextArgument(ci);
            this.announce(ci, "bind", name, obj);
            this.getContext().bind(name, obj);
        }
        catch (Exception name) {
            void e;
            FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.jndi.internal.JNDIConsole", (String)"115", (Object)this, (Object[])new Object[]{ci});
            this.handleEx(ci, (Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void _jndirebind(CommandInterpreter ci) {
        try {
            String name = ci.nextArgument();
            Object obj = this.parseNextArgument(ci);
            this.announce(ci, "rebind", name, obj);
            this.getContext().rebind(name, obj);
        }
        catch (Exception name) {
            void e;
            FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.jndi.internal.JNDIConsole", (String)"126", (Object)this, (Object[])new Object[]{ci});
            this.handleEx(ci, (Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void _jndiunbind(CommandInterpreter ci) {
        try {
            String name = ci.nextArgument();
            this.announce(ci, "unbind", name);
            this.getContext().unbind(name);
        }
        catch (Exception name) {
            void e;
            FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.jndi.internal.JNDIConsole", (String)"136", (Object)this, (Object[])new Object[]{ci});
            this.handleEx(ci, (Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void _jndirename(CommandInterpreter ci) {
        try {
            String oldName = ci.nextArgument();
            String newName = ci.nextArgument();
            this.announce(ci, "rename", oldName, newName);
            this.getContext().rename(oldName, newName);
        }
        catch (Exception oldName) {
            void e;
            FFDCFilter.processException((Throwable)oldName, (String)"com.ibm.ws.jndi.internal.JNDIConsole", (String)"147", (Object)this, (Object[])new Object[]{ci});
            this.handleEx(ci, (Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void _jndicreatesc(CommandInterpreter ci) {
        try {
            String name = ci.nextArgument();
            this.announce(ci, "createSubcontext", name);
            this.getContext().createSubcontext(name);
        }
        catch (Exception name) {
            void e;
            FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.jndi.internal.JNDIConsole", (String)"157", (Object)this, (Object[])new Object[]{ci});
            this.handleEx(ci, (Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void _jndidestroysc(CommandInterpreter ci) {
        try {
            String name = ci.nextArgument();
            this.announce(ci, "destroySubcontext", name);
            this.getContext().destroySubcontext(name);
        }
        catch (Exception name) {
            void e;
            FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.jndi.internal.JNDIConsole", (String)"167", (Object)this, (Object[])new Object[]{ci});
            this.handleEx(ci, (Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void _jndireset(CommandInterpreter ci) {
        try {
            ci.println((Object)"context = null");
            this.ctx = null;
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jndi.internal.JNDIConsole", (String)"176", (Object)this, (Object[])new Object[]{ci});
            this.handleEx(ci, (Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void _jndicd(CommandInterpreter ci) {
        try {
            String name = ci.nextArgument();
            Object o = this.getContext().lookup(name);
            Context c = (Context)o;
            ci.println((Object)("context = " + c));
            this.ctx = c;
        }
        catch (Exception name) {
            void e;
            FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.jndi.internal.JNDIConsole", (String)"188", (Object)this, (Object[])new Object[]{ci});
            this.handleEx(ci, (Exception)e);
        }
    }

    public String getHelp() {
        return String.format("---JNDI utilities---%n\tjndilist%n\tjndilist <name>...%n\tjndilookup <name>%n\tjndibind <name> <object>%n\tjndirebind <name> <object>%n\tjndiunbind <name>%n\tjndirename <name> <name>%n\tjndicreatesc <name>%n\tjndidestroysc <name>%n\tjndicd <name>%n\tjndireset%n", new Object[0]);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JNDIConsole.class);
    }
}

