/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.util;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.javaee.dd.common.ParamValue;
import com.ibm.ws.javaee.dd.jsf.FacesConfig;
import com.ibm.ws.javaee.dd.jsf.FacesConfigManagedBean;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInjectionClassListCollaborator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="log", fieldDesc="Ljava/util/logging/Logger;")
public class JSFInjectionClassListCollaborator
implements WebAppInjectionClassListCollaborator {
    protected static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.ibm.ws.jsf.util.JSFInjectionClassListCollaborator";
    public static final String FACES_CONFIG_NAMES = "javax.faces.CONFIG_FILES";
    private final String[] _InjectionInterfaces;
    private final String[] _InjectionSubClasses;
    static final long serialVersionUID = -737979922452332916L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JSFInjectionClassListCollaborator() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "<init>", new Object[0]);
        }
        this._InjectionInterfaces = new String[]{"javax.faces.event.ActionListener", "javax.faces.event.SystemEventListener", "javax.faces.event.PhaseListener"};
        this._InjectionSubClasses = new String[]{"javax.el.ELResolver", "javax.faces.application.ApplicationFactory", "javax.faces.application.NavigationHandler", "javax.faces.application.ResourceHandler", "javax.faces.application.StateManager", "javax.faces.component.visit.VisitContextFactory", "javax.faces.context.ExceptionHandlerFactory", "javax.faces.context.ExternalContextFactory", "javax.faces.context.FacesContextFactory", "javax.faces.context.PartialViewContextFactory", "javax.faces.lifecycle.ClientWindowFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory", "javax.faces.view.ViewDeclarationLanguageFactory", "javax.faces.view.facelets.FaceletCacheFactory", "javax.faces.view.facelets.TagHandlerDelegateFactory"};
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void activate(ComponentContext compcontext) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "activate", new Object[]{compcontext});
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void deactivate(ComponentContext compcontext) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "deactivate", new Object[]{compcontext});
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "deactivate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getInjectionClasses(Container moduleContainer) {
        ArrayList<String> classList;
        block17: {
            block16: {
                if (log != null && log.isLoggable(Level.FINER)) {
                    log.entering(CLASS_NAME, "getInjectionClasses", new Object[]{moduleContainer});
                }
                classList = new ArrayList<String>();
                try {
                    WebAnnotations webAnnotations = (WebAnnotations)moduleContainer.adapt(WebAnnotations.class);
                    AnnotationTargets_Targets annotationTargets = webAnnotations.getAnnotationTargets();
                    Set managedBeanClassNames = annotationTargets.getAllInheritedAnnotatedClasses("javax.faces.bean.ManagedBean", AnnotationTargets_Targets.POLICY_SEED);
                    if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
                        Iterator mbcI = managedBeanClassNames.iterator();
                        while (mbcI.hasNext()) {
                            log.logp(Level.FINE, CLASS_NAME, "getInjectionClasses", "MangagedBean :" + (String)mbcI.next());
                        }
                    }
                    classList.addAll(managedBeanClassNames);
                    for (String injectionInterface : this._InjectionInterfaces) {
                        managedBeanClassNames = annotationTargets.getAllImplementorsOf(injectionInterface);
                        for (String mbcn : managedBeanClassNames) {
                            if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
                                log.logp(Level.FINE, CLASS_NAME, "getInjectionClasses", "Found implementor of " + injectionInterface + " : " + mbcn);
                            }
                            if (classList.contains(mbcn)) continue;
                            classList.add(mbcn);
                            if (!TraceComponent.isAnyTracingEnabled() || !log.isLoggable(Level.FINE)) continue;
                            log.logp(Level.FINE, CLASS_NAME, "getInjectionClasses", "Add implementor :" + mbcn);
                        }
                    }
                    for (String injectionSubClass : this._InjectionSubClasses) {
                        managedBeanClassNames = annotationTargets.getSubclassNames(injectionSubClass);
                        for (String mbcn : managedBeanClassNames) {
                            if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
                                log.logp(Level.FINE, CLASS_NAME, "getInjectionClasses", "Found extender of " + injectionSubClass + " : " + mbcn);
                            }
                            if (classList.contains(mbcn) || mbcn.equals(injectionSubClass + "Wrapper")) continue;
                            classList.add(mbcn);
                            if (!TraceComponent.isAnyTracingEnabled() || !log.isLoggable(Level.FINE)) continue;
                            log.logp(Level.FINE, CLASS_NAME, "getInjectionClasses", "Add sub class :" + mbcn);
                        }
                    }
                }
                catch (UnableToAdaptException e) {
                    if (!log.isLoggable(Level.FINE)) break block16;
                    log.logp(Level.FINE, CLASS_NAME, "getInjectionClasses", "failed to adapt to InfoStore for class annotations", e);
                }
            }
            try {
                FacesConfig facesConfig = (FacesConfig)moduleContainer.adapt(FacesConfig.class);
                if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "getInjectionClasses", "Add managed objects from WEB-INF/faces-config.xml");
                }
                this.addConfigFileManagedObjects(facesConfig, classList);
            }
            catch (UnableToAdaptException e) {
                if (!log.isLoggable(Level.FINE)) break block17;
                log.logp(Level.FINE, CLASS_NAME, "getInjectionClasses", "failed to adapt to default faces-config in Container", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "getInjectionClasses", "Add managed objects from META-INF/faces-config.xml");
        }
        this.addConfigFileBeans(moduleContainer.getEntry("META-INF/faces-config.xml"), classList);
        this.searchJars(moduleContainer, classList);
        this.addAlternateNamedFacesConfig(moduleContainer, classList);
        ArrayList<String> arrayList = classList;
        if (log != null && log.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            log.exiting(CLASS_NAME, "getInjectionClasses", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addAlternateNamedFacesConfig(Container moduleContainer, ArrayList<String> classList) {
        block12: {
            String configNames;
            block11: {
                WebApp webapp;
                block10: {
                    if (log != null && log.isLoggable(Level.FINER)) {
                        log.entering(CLASS_NAME, "addAlternateNamedFacesConfig", new Object[]{moduleContainer, classList});
                    }
                    webapp = (WebApp)moduleContainer.adapt(WebApp.class);
                    if (webapp != null) break block10;
                    if (log != null && log.isLoggable(Level.FINER)) {
                        log.exiting(CLASS_NAME, "addAlternateNamedFacesConfig");
                    }
                    return;
                }
                List params = webapp.getContextParams();
                configNames = null;
                for (ParamValue param : params) {
                    if (!param.getName().equals(FACES_CONFIG_NAMES)) continue;
                    configNames = param.getValue();
                    break;
                }
                if (configNames != null) break block11;
                if (log != null && log.isLoggable(Level.FINER)) {
                    log.exiting(CLASS_NAME, "addAlternateNamedFacesConfig");
                }
                return;
            }
            try {
                StringTokenizer st = new StringTokenizer(configNames, ",");
                while (st.hasMoreTokens()) {
                    this.addConfigFileBeans(moduleContainer.getEntry(st.nextToken()), classList);
                }
            }
            catch (UnableToAdaptException e) {
                if (!log.isLoggable(Level.FINE)) break block12;
                log.logp(Level.FINE, CLASS_NAME, "addAlternateNamedFacesConfig", "failed to adapt conatiner to WebApp", e);
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "addAlternateNamedFacesConfig");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void searchJars(Container moduleContainer, List<String> classList) {
        block14: {
            if (log != null && log.isLoggable(Level.FINER)) {
                log.entering(CLASS_NAME, "searchJars", new Object[]{moduleContainer, classList});
            }
            Entry webinfLibEntry = moduleContainer.getEntry("WEB-INF/lib");
            if (webinfLibEntry == null) {
                if (log != null && log.isLoggable(Level.FINER)) {
                    log.exiting(CLASS_NAME, "searchJars");
                }
                return;
            }
            try {
                Container c = (Container)webinfLibEntry.adapt(Container.class);
                for (Entry current : c) {
                    if (!current.getName().endsWith(".jar")) continue;
                    try {
                        Container jarContainer = (Container)current.adapt(Container.class);
                        if (jarContainer == null) continue;
                        this.addConfigFileBeans(jarContainer.getEntry("META-INF/faces-config.xml"), classList);
                        Entry metainf = jarContainer.getEntry("META-INF");
                        if (metainf == null) {
                            if (log != null && log.isLoggable(Level.FINER)) {
                                log.exiting(CLASS_NAME, "searchJars");
                            }
                            return;
                        }
                        Container metainfContainer = (Container)metainf.adapt(Container.class);
                        for (Entry currentEntry : metainfContainer) {
                            if (!currentEntry.getName().endsWith(".faces-config.xml")) continue;
                            this.addConfigFileBeans(currentEntry, classList);
                        }
                    }
                    catch (UnableToAdaptException e) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.logp(Level.FINE, CLASS_NAME, "searchJars", "unable to adapt jar or META-INF dir in jar named " + current.getName() + " to a container", e);
                    }
                }
            }
            catch (UnableToAdaptException e) {
                if (!log.isLoggable(Level.FINE)) break block14;
                log.logp(Level.FINE, CLASS_NAME, "searchJars", "unable to adapt WEB-INF/lib to a container", e);
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "searchJars");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addConfigFileBeans(Entry e, List<String> classList) {
        block6: {
            if (log != null && log.isLoggable(Level.FINER)) {
                log.entering(CLASS_NAME, "addConfigFileBeans", new Object[]{e, classList});
            }
            if (e == null) {
                if (log != null && log.isLoggable(Level.FINER)) {
                    log.exiting(CLASS_NAME, "addConfigFileBeans");
                }
                return;
            }
            try {
                FacesConfig facesConfig = (FacesConfig)e.adapt(FacesConfig.class);
                this.addConfigFileManagedObjects(facesConfig, classList);
            }
            catch (UnableToAdaptException ex) {
                if (!log.isLoggable(Level.FINE)) break block6;
                log.logp(Level.FINE, CLASS_NAME, "getInjectionClasses", "failed to adapt to faces-config from entry:" + e, ex);
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "addConfigFileBeans");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addConfigFileManagedObjects(FacesConfig facesConfig, List<String> classList) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "addConfigFileManagedObjects", new Object[]{facesConfig, classList});
        }
        if (facesConfig != null) {
            List beans = facesConfig.getManagedBeans();
            for (FacesConfigManagedBean bean : beans) {
                classList.add(bean.getManagedBeanClass());
            }
            List objects = facesConfig.getManagedObjects();
            for (String object : objects) {
                if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "addConfigFileManagedObjects", "Found config managed object :" + object);
                }
                if (classList.contains(object)) continue;
                if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "addConfigFileManagedObjects", "Add config managed object :" + object);
                }
                classList.add(object);
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "addConfigFileManagedObjects");
        }
    }
}

