/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.web.common.WebAppType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebAppDDParser
extends DDParser {
    private final int maxVersion;
    private static final String WEBAPP_DTD_PUBLIC_ID_22 = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    private static final String WEBAPP_DTD_PUBLIC_ID_23 = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    static final long serialVersionUID = 6592617422668928204L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WebAppDDParser(Container ddRootContainer, Entry ddEntry, int version) throws DDParser.ParseException {
        super(ddRootContainer, ddEntry);
        this.trimSimpleContentAsRequiredByServletSpec = true;
        this.maxVersion = version;
    }

    WebApp parse() throws DDParser.ParseException {
        super.parseRootElement();
        return (WebApp)this.rootParsable;
    }

    @Override
    protected DDParser.ParsableElement createRootParsable() throws DDParser.ParseException {
        if (!"web-app".equals(this.rootElementLocalName)) {
            throw new DDParser.ParseException(this.invalidRootElement());
        }
        String vers = this.getAttributeValue("", "version");
        if (vers == null) {
            if (this.namespace == null && this.dtdPublicId != null) {
                if (WEBAPP_DTD_PUBLIC_ID_22.equals(this.dtdPublicId)) {
                    this.version = 22;
                    this.eePlatformVersion = 12;
                    return new WebAppType(this.getDeploymentDescriptorPath());
                }
                if (WEBAPP_DTD_PUBLIC_ID_23.equals(this.dtdPublicId)) {
                    this.version = 23;
                    this.eePlatformVersion = 13;
                    return new WebAppType(this.getDeploymentDescriptorPath());
                }
            }
            throw new DDParser.ParseException(this.unknownDeploymentDescriptorVersion());
        }
        this.runtimeVersion = this.maxVersion == 31 ? 70 : 60;
        if ("2.4".equals(vers)) {
            if ("http://java.sun.com/xml/ns/j2ee".equals(this.namespace)) {
                this.version = 24;
                this.eePlatformVersion = 14;
                return new WebAppType(this.getDeploymentDescriptorPath());
            }
        } else if ("2.5".equals(vers)) {
            if ("http://java.sun.com/xml/ns/javaee".equals(this.namespace)) {
                this.version = 25;
                this.eePlatformVersion = 50;
                return new WebAppType(this.getDeploymentDescriptorPath());
            }
        } else if ("3.0".equals(vers)) {
            if ("http://java.sun.com/xml/ns/javaee".equals(this.namespace)) {
                this.version = 30;
                this.eePlatformVersion = 60;
                return new WebAppType(this.getDeploymentDescriptorPath());
            }
        } else if (this.maxVersion >= 31 && "3.1".equals(vers) && "http://xmlns.jcp.org/xml/ns/javaee".equals(this.namespace)) {
            this.version = 31;
            this.eePlatformVersion = 70;
            return new WebAppType(this.getDeploymentDescriptorPath());
        }
        throw new DDParser.ParseException(this.invalidDeploymentDescriptorNamespace(vers));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WebAppDDParser.class);
    }
}

