/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FailureScopeFactory;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FileFailureScopeFactory
implements FailureScopeFactory {
    private static final com.ibm.tx.util.logging.TraceComponent tc;
    private static final byte VERSION = 2;
    static final long serialVersionUID = -3388512732663541902L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    @Override
    public FailureScope toFailureScope(byte[] bytes) {
        byte version;
        DataInputStream dis;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"toFailureScope", (Object)new Object[]{RLSUtils.toHexString(bytes), this});
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            dis = new DataInputStream(bais);
            version = 0;
            try {
                byte failureScopeID = dis.readByte();
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("FailureScope version manager id is " + failureScopeID));
                }
                version = dis.readByte();
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("FailureScope version is " + version));
                }
            }
            catch (IOException failureScopeID) {
                void ioe;
                com.ibm.ws.ffdc.FFDCFilter.processException((Throwable)failureScopeID, (String)"com.ibm.ws.recoverylog.spi.FileFailureScopeFactory", (String)"84", (Object)this, (Object[])new Object[]{bytes});
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.recoverylog.spi.FileFailureScopeFactory.toFailureScope", (String)"61", (Object)this);
                if (!tc.isEventEnabled()) break block12;
                Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"IOException caught inflating failure scope", (Object)ioe);
            }
        }
        FileFailureScope failureScope = null;
        if (version == 2) {
            try {
                String serverName = dis.readUTF();
                failureScope = new FileFailureScope(serverName);
            }
            catch (IOException serverName) {
                void ioe;
                com.ibm.ws.ffdc.FFDCFilter.processException((Throwable)serverName, (String)"com.ibm.ws.recoverylog.spi.FileFailureScopeFactory", (String)"101", (Object)this, (Object[])new Object[]{bytes});
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.recoverylog.spi.FileFailureScopeFactory.toFailureScope", (String)"68", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"IOException caught inflating failure scope", (Object)ioe);
                }
            }
        } else if (tc.isEventEnabled()) {
            Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"FailureScope version level not recognized. Expected version 2");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"toFailureScope", (Object)failureScope);
        }
        return failureScope;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toByteArray(FailureScope failureScope) {
        byte[] bytes;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"toByteArray", (Object)new Object[]{failureScope, this});
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            bytes = null;
            try {
                dos.writeByte(FailureScopeFactory.FILE_FAILURE_SCOPE_ID.byteValue());
                dos.writeByte(2);
                dos.writeUTF(failureScope.serverName());
                dos.flush();
                dos.close();
                bytes = baos.toByteArray();
            }
            catch (IOException iOException) {
                void ioe;
                com.ibm.ws.ffdc.FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.FileFailureScopeFactory", (String)"149", (Object)this, (Object[])new Object[]{failureScope});
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.recoverylog.spi.FileFailureScopeFactory.toByteArray", (String)"104", (Object)this);
                if (!tc.isEventEnabled()) break block4;
                Tr.event((com.ibm.tx.util.logging.TraceComponent)tc, (String)"IOException caught deflating failure scope", (Object)ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"toByteArray", (Object)bytes);
        }
        return bytes;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(FileFailureScopeFactory.class);
        tc = Tr.register(FileFailureScopeFactory.class, (String)"Transaction", null);
    }
}

