/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transaction.services;

import com.ibm.tx.jta.embeddable.impl.EmbeddableTransactionImpl;
import com.ibm.tx.jta.embeddable.impl.WSATRecoveryCoordinator;
import com.ibm.tx.jta.impl.LocalTIDTable;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.ltc.impl.LocalTranCurrentSet;
import com.ibm.tx.remote.DistributableTransaction;
import com.ibm.tx.remote.RemoteTransactionController;
import com.ibm.tx.remote.TransactionWrapper;
import com.ibm.tx.remote.Vote;
import com.ibm.tx.util.TMHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.JTA.HeuristicHazardException;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RemoteTransactionController.class})
public class RemoteTransactionControllerService
implements RemoteTransactionController {
    private static final TraceComponent tc = Tr.register(RemoteTransactionControllerService.class);
    private static final ThreadLocal<UOWCoordinator> _threadUOWCoord = new ThreadLocal();
    private static final ThreadLocal<DistributableTransaction> _threadImportedTran = new ThreadLocal();
    private UOWCurrent _uowc;
    private TransactionManager _tm;
    static final long serialVersionUID = -685917707916978655L;

    @Reference
    protected void setUOWCurrent(UOWCurrent uowc) {
        this._uowc = uowc;
    }

    @Reference
    protected void setTransactionManager(TransactionManager tm) {
        this._tm = tm;
    }

    /*
     * WARNING - void declaration
     */
    public boolean importTransaction(String globalId, int expires) throws SystemException {
        UOWCoordinator uowCoord = this._uowc.getUOWCoord();
        _threadUOWCoord.set(uowCoord);
        if (uowCoord != null && uowCoord.isGlobal()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The Web Service request is a local invocation", (Object[])new Object[0]);
            }
            ((DistributableTransaction)uowCoord).resumeAssociation();
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The Web Service request is a remote invocation", (Object[])new Object[0]);
        }
        try {
            TMHelper.checkTMState();
        }
        catch (NotSupportedException notSupportedException) {
            void e;
            FFDCFilter.processException((Throwable)notSupportedException, (String)"com.ibm.ws.transaction.services.RemoteTransactionControllerService", (String)"99", (Object)this, (Object[])new Object[]{globalId, expires});
            SystemException se = new SystemException();
            se.initCause((Throwable)e);
            throw se;
        }
        LocalTransactionCoordinator ltc = LocalTranCurrentSet.instance().suspend();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Suspended LTC", (Object[])new Object[]{ltc});
        }
        boolean createdNewTransaction = false;
        DistributableTransaction tx = this.getTransactionForID(globalId);
        if (tx == null) {
            tx = new EmbeddableTransactionImpl(expires, globalId);
            createdNewTransaction = true;
            new TransactionWrapper((EmbeddableTransactionImpl)tx);
        }
        _threadImportedTran.set(tx);
        tx.addAssociation();
        try {
            this._tm.resume((Transaction)tx);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transaction.services.RemoteTransactionControllerService", (String)"130", (Object)this, (Object[])new Object[]{globalId, expires});
            SystemException se = new SystemException();
            se.initCause((Throwable)e);
            throw se;
        }
        return createdNewTransaction;
    }

    public void unimportTransaction(String globalId) throws SystemException {
        UOWCoordinator suspendedUOW;
        DistributableTransaction tx = _threadImportedTran.get();
        if (tx != null) {
            if (!globalId.equals(tx.getGlobalId())) {
                SystemException e = new SystemException();
                throw e;
            }
            Transaction suspendedTx = this._tm.suspend();
            if (suspendedTx != null && !tx.equals(suspendedTx)) {
                SystemException e = new SystemException();
                throw e;
            }
        }
        _threadImportedTran.set(null);
        if (tx != null) {
            tx.removeAssociation();
        }
        if ((suspendedUOW = _threadUOWCoord.get()) != null && !suspendedUOW.isGlobal()) {
            LocalTranCurrentSet.instance().resume((LocalTransactionCoordinator)suspendedUOW);
        }
        _threadUOWCoord.set(null);
    }

    public String exportTransaction() throws SystemException {
        UOWCoordinator uowCoord = this._uowc.getUOWCoord();
        if (uowCoord == null || !uowCoord.isGlobal()) {
            throw new SystemException("No global transaction");
        }
        ((DistributableTransaction)uowCoord).suspendAssociation();
        return ((DistributableTransaction)uowCoord).getGlobalId();
    }

    public void unexportTransaction(String globalId) throws SystemException {
        UOWCoordinator uowCoord = this._uowc.getUOWCoord();
        if (uowCoord == null || !uowCoord.isGlobal()) {
            throw new SystemException("No global transaction");
        }
        ((DistributableTransaction)uowCoord).resumeAssociation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean registerRemoteParticipant(String xaResFactoryFilter, Serializable xaResInfo, String globalId) throws SystemException {
        boolean retval = true;
        DistributableTransaction tx = this.getTransactionForID(globalId);
        if (tx == null) return false;
        tx.addAssociation();
        try {
            switch (tx.getStatus()) {
                case 0: 
                case 1: {
                    tx.enlistAsyncResource(xaResFactoryFilter, xaResInfo, tx.getXid());
                    return retval;
                }
                case 7: {
                    tx.setRollbackOnly();
                }
                default: {
                    retval = false;
                    return retval;
                }
            }
        }
        finally {
            tx.removeAssociation();
        }
    }

    private DistributableTransaction getTransactionForID(String globalId) {
        for (TransactionImpl tx : LocalTIDTable.getAllTransactions()) {
            if (globalId.equals(((DistributableTransaction)tx).getGlobalId())) {
                return (DistributableTransaction)tx;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Non matching GlobalId: " + ((DistributableTransaction)tx).getGlobalId()), (Object[])new Object[0]);
        }
        return null;
    }

    public boolean registerRecoveryCoordinator(String recoveryCoordinatorFactoryFilter, Serializable recoveryCoordinatorInfo, String globalId) throws SystemException {
        DistributableTransaction tx = this.getTransactionForID(globalId);
        WSATRecoveryCoordinator rc = new WSATRecoveryCoordinator(recoveryCoordinatorFactoryFilter, recoveryCoordinatorInfo, globalId);
        tx.setWSATRecoveryCoordinator(rc);
        return true;
    }

    public Vote prepare(String globalId) throws SystemException, HeuristicHazardException, HeuristicMixedException, RollbackException {
        TransactionWrapper t = TransactionWrapper.getTransactionWrapper((String)globalId);
        if (t != null) {
            return t.prepare();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No matching TransactionWrapper: " + globalId), (Object[])new Object[0]);
        }
        throw new SystemException();
    }

    public void commit(String globalId) throws SystemException, HeuristicHazardException, HeuristicRollbackException, HeuristicMixedException {
        TransactionWrapper t = TransactionWrapper.getTransactionWrapper((String)globalId);
        if (t != null) {
            t.commit();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No matching TransactionWrapper: " + globalId), (Object[])new Object[0]);
        }
    }

    public void rollback(String globalId) throws HeuristicHazardException, HeuristicCommitException, HeuristicMixedException, SystemException {
        TransactionWrapper t = TransactionWrapper.getTransactionWrapper((String)globalId);
        if (t == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No matching TransactionWrapper: " + globalId), (Object[])new Object[0]);
            }
            throw new SystemException();
        }
        t.rollback();
    }

    public void setRollbackOnly(String globalId) throws SystemException {
        DistributableTransaction tx = this.getTransactionForID(globalId);
        if (tx != null) {
            tx.setRollbackOnly();
        }
    }

    public boolean replayCompletion(String globalId) {
        DistributableTransaction tx = this.getTransactionForID(globalId);
        if (tx != null) {
            tx.replayCompletion();
            return true;
        }
        return false;
    }
}

