/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.kernel.boot.logging.LoggerHandlerManager;
import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.WsMessageRouter;
import com.ibm.ws.logging.WsTraceRouter;
import com.ibm.ws.logging.internal.PackageProcessor;
import com.ibm.ws.logging.internal.TraceSpecification;
import com.ibm.ws.logging.internal.WsLogRecord;
import com.ibm.ws.logging.internal.impl.BaseTraceFormatter;
import com.ibm.ws.logging.internal.impl.FileLogHeader;
import com.ibm.ws.logging.internal.impl.FileLogHolder;
import com.ibm.ws.logging.internal.impl.LogProviderConfigImpl;
import com.ibm.ws.logging.internal.impl.LoggingConstants;
import com.ibm.ws.logging.internal.impl.LoggingFileUtils;
import com.ibm.ws.logging.internal.impl.RoutedMessageImpl;
import com.ibm.ws.logging.internal.impl.SimpleRotatingSoftQueue;
import com.ibm.wsspi.logging.MessageRouter;
import com.ibm.wsspi.logprovider.LogProviderConfig;
import com.ibm.wsspi.logprovider.TrService;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class BaseTraceService
implements TrService {
    static final PrintStream rawSystemOut = System.out;
    static final PrintStream rawSystemErr = System.err;
    protected final SystemLogHolder systemOut;
    protected final SystemLogHolder systemErr;
    public static final Object NULL_ID = null;
    public static final Logger NULL_LOGGER = null;
    public static final String NULL_FORMATTED_MSG = null;
    protected final AtomicReference<MessageRouter> externalMessageRouter = new AtomicReference();
    protected final AtomicReference<WsMessageRouter> internalMessageRouter = new AtomicReference();
    protected final AtomicReference<WsTraceRouter> internalTraceRouter = new AtomicReference();
    protected volatile Level consoleLogLevel = WsLevel.AUDIT;
    protected volatile boolean copySystemStreams = true;
    protected volatile BaseTraceFormatter formatter;
    protected volatile boolean isoDateFormat = false;
    protected volatile TraceWriter messagesLog = null;
    protected volatile TraceWriter traceLog = null;
    protected TeePrintStream teeOut = null;
    protected TeePrintStream teeErr = null;
    private String logHeader;
    private boolean javaLangInstrument;
    private volatile Collection<String> hideMessageids;
    private final Queue<RoutedMessage> earlierMessages = new SimpleRotatingSoftQueue<RoutedMessage>(new RoutedMessage[100]);
    private final Queue<RoutedMessage> earlierTraces = new SimpleRotatingSoftQueue<RoutedMessage>(new RoutedMessage[200]);
    private static ThreadLocal<StackTraceFlags> traceFlags = new ThreadLocal<StackTraceFlags>(){

        @Override
        protected StackTraceFlags initialValue() {
            return new StackTraceFlags();
        }
    };

    public BaseTraceService() {
        this.systemOut = new SystemLogHolder("SystemOut", System.out);
        this.systemErr = new SystemLogHolder("SystemErr", System.err);
    }

    @Override
    public void init(LogProviderConfig config) {
        this.update(config);
        this.registerLoggerHandlerSingleton();
        this.captureSystemStreams();
    }

    protected void registerLoggerHandlerSingleton() {
        LoggerHandlerManager.setSingleton((Handler)new Handler(){

            @Override
            public void publish(LogRecord logRecord) {
                BaseTraceService.this.publishLogRecord(logRecord);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        });
    }

    protected void unregisterLoggerHandlerSingleton() {
        LoggerHandlerManager.unsetSingleton();
    }

    @Override
    public synchronized void update(LogProviderConfig config) {
        LogProviderConfigImpl trConfig = (LogProviderConfigImpl)config;
        this.logHeader = trConfig.getLogHeader();
        this.javaLangInstrument = trConfig.hasJavaLangInstrument();
        this.consoleLogLevel = trConfig.getConsoleLogLevel();
        this.copySystemStreams = trConfig.copySystemStreams();
        this.hideMessageids = trConfig.getMessagesToHide();
        if (this.hideMessageids.size() > 0) {
            this.logHeader = this.logHeader.concat("Suppressed message ids: " + this.hideMessageids).concat(LoggingConstants.nl);
        }
        if (this.formatter == null || trConfig.getTraceFormat() != this.formatter.getTraceFormat()) {
            this.formatter = new BaseTraceFormatter(trConfig.getTraceFormat());
        }
        this.isoDateFormat = trConfig.getIsoDateFormat();
        if (this.isoDateFormat != BaseTraceFormatter.useIsoDateFormat) {
            BaseTraceFormatter.useIsoDateFormat = this.isoDateFormat;
        }
        this.initializeWriters(trConfig);
        if (this.hideMessageids.size() > 0) {
            Tr.info(TraceSpecification.getTc(), "MESSAGES_CONFIGURED_HIDDEN_2", this.hideMessageids);
        }
    }

    @Override
    public void stop() {
        this.restoreSystemStreams();
        this.unregisterLoggerHandlerSingleton();
        LoggingFileUtils.tryToClose(this.messagesLog);
        LoggingFileUtils.tryToClose(this.traceLog);
    }

    @Override
    public void register(TraceComponent tc) {
    }

    @Override
    public void info(TraceComponent tc, String msgKey, Object ... o) {
        WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.INFO, msgKey, o);
        this.publishLogRecord(logRecord);
    }

    @Override
    public void audit(TraceComponent tc, String msgKey, Object ... o) {
        WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, WsLevel.AUDIT, msgKey, o);
        this.publishLogRecord(logRecord);
    }

    @Override
    public void warning(TraceComponent tc, String msgKey, Object ... o) {
        WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.WARNING, msgKey, o);
        this.publishLogRecord(logRecord);
    }

    @Override
    public void error(TraceComponent tc, String msgKey, Object ... o) {
        WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, WsLevel.ERROR, msgKey, o);
        this.publishLogRecord(logRecord);
    }

    @Override
    public void fatal(TraceComponent tc, String msgKey, Object ... o) {
        WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, WsLevel.FATAL, msgKey, o);
        this.publishLogRecord(logRecord);
    }

    @Override
    public void debug(TraceComponent tc, String txt, Object ... o) {
        if (tc.isDebugEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINEST, txt, o);
            this.publishTraceLogRecord(this.traceLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void debug(TraceComponent tc, Object id, String txt, Object ... o) {
        if (tc.isDebugEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINEST, txt, o);
            this.publishTraceLogRecord(this.traceLog, logRecord, id, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void entry(TraceComponent tc, String methodName, Object ... o) {
        if (tc.isEntryEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINER, "Entry ", o);
            logRecord.setSourceMethodName(methodName);
            this.publishTraceLogRecord(this.traceLog, logRecord, null, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void entry(TraceComponent tc, Object id, String methodName, Object ... o) {
        if (tc.isEntryEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINER, "Entry ", o);
            logRecord.setSourceMethodName(methodName);
            this.publishTraceLogRecord(this.traceLog, logRecord, id, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void event(TraceComponent tc, String txt, Object ... o) {
        if (tc.isEventEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, WsLevel.EVENT, txt, o);
            this.publishTraceLogRecord(this.traceLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void event(TraceComponent tc, Object id, String txt, Object ... o) {
        if (tc.isEventEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, WsLevel.EVENT, txt, o);
            this.publishTraceLogRecord(this.traceLog, logRecord, id, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void exit(TraceComponent tc, String methodName) {
        if (tc.isEntryEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINER, "Exit ", null);
            logRecord.setSourceMethodName(methodName);
            this.publishTraceLogRecord(this.traceLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void exit(TraceComponent tc, Object id, String methodName) {
        if (tc.isEntryEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINER, "Exit ", null);
            logRecord.setSourceMethodName(methodName);
            this.publishTraceLogRecord(this.traceLog, logRecord, id, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void exit(TraceComponent tc, String methodName, Object o) {
        if (tc.isEntryEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINER, "Exit ", new Object[]{o});
            logRecord.setSourceMethodName(methodName);
            this.publishTraceLogRecord(this.traceLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void exit(TraceComponent tc, Object id, String methodName, Object o) {
        if (tc.isEntryEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINER, "Exit ", new Object[]{o});
            logRecord.setSourceMethodName(methodName);
            this.publishTraceLogRecord(this.traceLog, logRecord, id, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    @Override
    public void dump(TraceComponent tc, String txt, Object ... o) {
        if (tc.isDumpEnabled()) {
            WsLogRecord logRecord = WsLogRecord.createWsLogRecord(tc, Level.FINEST, "Dump: " + txt, o);
            this.publishTraceLogRecord(this.traceLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        }
    }

    public void echo(SystemLogHolder holder, LogRecord logRecord) {
        TraceWriter detailLog = this.traceLog;
        String message = this.formatter.messageLogFormat(logRecord, logRecord.getMessage());
        this.messagesLog.writeRecord(message);
        this.invokeMessageRouters(new RoutedMessageImpl(logRecord.getMessage(), logRecord.getMessage(), message, logRecord));
        if (detailLog == this.systemOut) {
            this.publishTraceLogRecord(holder, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        } else {
            if (this.copySystemStreams) {
                this.writeFilteredStreamOutput(holder, logRecord);
            }
            if (TraceComponent.isAnyTracingEnabled()) {
                this.publishTraceLogRecord(detailLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
            }
        }
    }

    protected void writeFilteredStreamOutput(SystemLogHolder holder, LogRecord logRecord) {
        String txt = this.filterStackTraces(logRecord.getMessage());
        if (txt != null) {
            this.writeStreamOutput(holder, txt, true);
        }
    }

    protected boolean isMessageHidden(String formattedMsg) {
        for (String messageId : this.hideMessageids) {
            if (!formattedMsg.startsWith(messageId)) continue;
            return true;
        }
        return false;
    }

    protected boolean invokeMessageRouters(RoutedMessage routedMessage) {
        MessageRouter externalMsgRouter = this.externalMessageRouter.get();
        WsMessageRouter internalMsgRouter = this.internalMessageRouter.get();
        boolean retMe = true;
        if (externalMsgRouter != null) {
            retMe &= externalMsgRouter.route(routedMessage.getFormattedMsg(), routedMessage.getLogRecord());
        }
        if (internalMsgRouter != null) {
            retMe &= internalMsgRouter.route(routedMessage);
        } else {
            this.earlierMessages.add(routedMessage);
        }
        return retMe;
    }

    protected boolean invokeTraceRouters(RoutedMessage routedTrace) {
        String levelName;
        Level level;
        int levelValue;
        boolean retMe = true;
        LogRecord logRecord = routedTrace.getLogRecord();
        if (logRecord != null && (levelValue = (level = logRecord.getLevel()).intValue()) < Level.INFO.intValue() && !(levelName = level.getName()).equals("SystemOut") && !levelName.equals("SystemErr")) {
            WsTraceRouter internalTrRouter = this.internalTraceRouter.get();
            if (internalTrRouter != null) {
                retMe &= internalTrRouter.route(routedTrace);
            } else {
                this.earlierTraces.add(routedTrace);
            }
        }
        return retMe;
    }

    @Override
    public void publishLogRecord(LogRecord logRecord) {
        String formattedMsg = null;
        String formattedVerboseMsg = null;
        Level level = logRecord.getLevel();
        int levelValue = level.intValue();
        TraceWriter detailLog = this.traceLog;
        if (levelValue >= Level.INFO.intValue()) {
            String messageLogFormat;
            formattedMsg = this.formatter.formatMessage(logRecord);
            boolean logNormally = this.invokeMessageRouters(new RoutedMessageImpl(formattedMsg, formattedVerboseMsg = this.formatter.formatVerboseMessage(logRecord, formattedMsg), messageLogFormat = this.formatter.messageLogFormat(logRecord, formattedVerboseMsg), logRecord));
            if (!logNormally) {
                return;
            }
            if (this.isMessageHidden(formattedMsg)) {
                this.publishTraceLogRecord(detailLog, logRecord, NULL_ID, formattedMsg, formattedVerboseMsg);
                return;
            }
            this.messagesLog.writeRecord(messageLogFormat);
            if (detailLog == this.systemOut) {
                if (levelValue == WsLevel.ERROR.intValue() || levelValue == WsLevel.FATAL.intValue()) {
                    this.publishTraceLogRecord(this.systemErr, logRecord, NULL_ID, formattedMsg, formattedVerboseMsg);
                } else {
                    this.publishTraceLogRecord(this.systemOut, logRecord, NULL_ID, formattedMsg, formattedVerboseMsg);
                }
                return;
            }
            if (levelValue >= this.consoleLogLevel.intValue()) {
                String consoleMsg = this.formatter.consoleLogFormat(logRecord, formattedMsg);
                if (levelValue == WsLevel.ERROR.intValue() || levelValue == WsLevel.FATAL.intValue()) {
                    this.writeStreamOutput(this.systemErr, consoleMsg, false);
                } else {
                    this.writeStreamOutput(this.systemOut, consoleMsg, false);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            this.publishTraceLogRecord(detailLog, logRecord, NULL_ID, formattedMsg, formattedVerboseMsg);
        }
    }

    protected void publishTraceLogRecord(TraceWriter detailLog, LogRecord logRecord, Object id, String formattedMsg, String formattedVerboseMsg) {
        if (formattedVerboseMsg == null) {
            formattedVerboseMsg = this.formatter.formatVerboseMessage(logRecord, formattedMsg, false);
        }
        String traceDetail = this.formatter.traceLogFormat(logRecord, id, formattedMsg, formattedVerboseMsg);
        this.invokeTraceRouters(new RoutedMessageImpl(formattedMsg, formattedVerboseMsg, traceDetail, logRecord));
        if (detailLog == this.systemOut || detailLog == this.systemErr) {
            this.writeStreamOutput((SystemLogHolder)detailLog, traceDetail, false);
        } else {
            detailLog.writeRecord(traceDetail);
        }
    }

    @Override
    public void setMessageRouter(MessageRouter msgRouter) {
        this.externalMessageRouter.set(msgRouter);
        if (msgRouter instanceof WsMessageRouter) {
            this.setWsMessageRouter((WsMessageRouter)msgRouter);
        }
    }

    @Override
    public void unsetMessageRouter(MessageRouter msgRouter) {
        this.externalMessageRouter.compareAndSet(msgRouter, null);
        if (msgRouter instanceof WsMessageRouter) {
            this.unsetWsMessageRouter((WsMessageRouter)msgRouter);
        }
    }

    protected void setWsMessageRouter(WsMessageRouter msgRouter) {
        this.internalMessageRouter.set(msgRouter);
        msgRouter.setEarlierMessages(this.earlierMessages);
    }

    public void unsetWsMessageRouter(WsMessageRouter msgRouter) {
        this.internalMessageRouter.compareAndSet(msgRouter, null);
    }

    @Override
    public void setTraceRouter(WsTraceRouter traceRouter) {
        this.internalTraceRouter.set(traceRouter);
        traceRouter.setEarlierTraces(this.earlierTraces);
    }

    @Override
    public void unsetTraceRouter(WsTraceRouter traceRouter) {
        this.internalTraceRouter.compareAndSet(traceRouter, null);
    }

    protected void initializeWriters(LogProviderConfigImpl config) {
        this.messagesLog = FileLogHolder.createFileLogHolder(this.messagesLog, this.newFileLogHeader(false), config.getLogDirectory(), config.getMessageFileName(), config.getMaxFiles(), config.getMaxFileBytes());
        TraceWriter oldWriter = this.traceLog;
        String fileName = config.getTraceFileName();
        if (fileName.equals("stdout")) {
            this.traceLog = this.systemOut;
            LoggingFileUtils.tryToClose(oldWriter);
        } else {
            this.traceLog = FileLogHolder.createFileLogHolder(oldWriter == this.systemOut ? null : oldWriter, this.newFileLogHeader(true), config.getLogDirectory(), config.getTraceFileName(), config.getMaxFiles(), config.getMaxFileBytes());
            if (!TraceComponent.isAnyTracingEnabled()) {
                ((FileLogHolder)this.traceLog).releaseFile();
            }
        }
    }

    private FileLogHeader newFileLogHeader(boolean trace) {
        return new FileLogHeader(this.logHeader, trace, this.javaLangInstrument);
    }

    protected void captureSystemStreams() {
        this.teeOut = new TeePrintStream(new TrOutputStream(this.systemOut, this), true);
        System.setOut(this.teeOut);
        this.teeErr = new TeePrintStream(new TrOutputStream(this.systemErr, this), true);
        System.setErr(this.teeErr);
    }

    protected void restoreSystemStreams() {
        if (System.out == this.teeOut) {
            System.setOut(this.systemOut.getOriginalStream());
        }
        if (System.err == this.teeErr) {
            System.setErr(this.systemErr.getOriginalStream());
        }
    }

    protected synchronized void writeStreamOutput(SystemLogHolder holder, String txt, boolean rawStream) {
        if (holder == this.systemErr && rawStream) {
            txt = "[err] " + txt;
        }
        holder.originalStream.println(txt);
    }

    private String filterStackTraces(String txt) {
        StackTraceFlags stackTraceFlags = traceFlags.get();
        if (txt.startsWith("\tat ")) {
            PackageProcessor packageProcessor = PackageProcessor.getPackageProcessor();
            String packageName = PackageProcessor.extractPackageFromStackTraceLine(txt);
            if (packageProcessor != null && packageProcessor.isIBMPackage(packageName)) {
                if (stackTraceFlags.isSuppressingTraces) {
                    txt = null;
                } else if (stackTraceFlags.needsToOutputInternalPackageMarker) {
                    txt = "\tat [internal classes]";
                    stackTraceFlags.needsToOutputInternalPackageMarker = false;
                    stackTraceFlags.isSuppressingTraces = true;
                } else {
                    stackTraceFlags.needsToOutputInternalPackageMarker = true;
                }
            } else {
                stackTraceFlags.isSuppressingTraces = false;
                stackTraceFlags.needsToOutputInternalPackageMarker = false;
            }
        } else {
            stackTraceFlags.isSuppressingTraces = false;
            stackTraceFlags.needsToOutputInternalPackageMarker = false;
        }
        return txt;
    }

    public static class TrOutputStream
    extends ByteArrayOutputStream {
        final SystemLogHolder holder;
        final BaseTraceService service;

        public TrOutputStream(SystemLogHolder slh, BaseTraceService service) {
            this.holder = slh;
            this.service = service;
        }

        @Override
        public synchronized void flush() throws IOException {
            super.flush();
            if (!this.holder.isEnabled()) {
                super.reset();
                return;
            }
            String entry = this.toString();
            super.reset();
            if (entry.isEmpty() || LoggingConstants.nl.equals(entry)) {
                return;
            }
            if (entry.endsWith(LoggingConstants.nl)) {
                entry = entry.substring(0, entry.length() - LoggingConstants.nlen);
            }
            LogRecord logRecord = new LogRecord(this.holder, entry);
            logRecord.setLoggerName(this.holder.getName());
            this.service.echo(this.holder, logRecord);
        }
    }

    public static final class TeePrintStream
    extends PrintStream {
        protected final TrOutputStream trStream;

        public TeePrintStream(TrOutputStream trStream, boolean autoFlush) {
            super(trStream, autoFlush);
            this.trStream = trStream;
        }
    }

    public static final class SystemLogHolder
    extends Level
    implements TraceWriter {
        private static final long serialVersionUID = 1L;
        final transient PrintStream originalStream;
        final transient TraceComponent tc;

        protected SystemLogHolder(String name, PrintStream origin) {
            super(name, WsLevel.CONFIG.intValue());
            this.originalStream = origin;
            this.tc = Tr.register(name, SystemLogHolder.class, (String)null);
        }

        public PrintStream getOriginalStream() {
            return this.originalStream;
        }

        @Override
        public void writeRecord(String record) {
            this.originalStream.println(record);
        }

        @Override
        public void close() throws IOException {
        }

        public boolean isEnabled() {
            return this.tc.getLoggerLevel() != Level.OFF;
        }
    }

    private static class StackTraceFlags {
        boolean needsToOutputInternalPackageMarker = false;
        boolean isSuppressingTraces = false;

        private StackTraceFlags() {
        }
    }

    public static interface TraceWriter
    extends Closeable {
        public void writeRecord(String var1);
    }
}

