/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.DistributedObjectCacheAdapter;
import com.ibm.ws.cache.ObjectCacheUnitImpl;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.intf.ObjectCacheUnit;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.DistributedObjectCacheFactory;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ObjectCacheServiceImpl
implements ServletContextListener,
ServletContainerInitializer {
    private static TraceComponent tc = Tr.register(ObjectCacheServiceImpl.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static ObjectCacheUnit objectCacheUnit = new ObjectCacheUnitImpl();
    private final AtomicReference<ServerCache> serverCacheReference = new AtomicReference<Object>(null);
    private final AtomicReference<VariableRegistry> variableRegistryRef = new AtomicReference<Object>(null);
    public static final String CACHE_INSTANCES_PROPERTIES = "cacheinstances.properties";
    public static final String DISTRIBUTED_MAP_PROPERTIES = "distributedmap.properties";
    public static final String WEB_INF_CACHE_INSTANCES_PROPERTIES = "WEB-INF/cacheinstances.properties";
    public static final String WEB_INF_DISTRIBUTED_MAP_PROPERTIES = "WEB-INF/distributedmap.properties";
    private final Set<URL> processedUrls = new CopyOnWriteArraySet<URL>();

    protected void start() throws RuntimeWarning, RuntimeError {
        String methodName = "start()";
        CacheService cacheService = this.getCacheService();
        if (null == cacheService) {
            throw new RuntimeError("Core Cache Service is NOT available");
        }
        CacheConfig cacheConfigTemplate = cacheService.getCacheConfig();
        try {
            ServerCache.objectCacheEnabled = true;
            this.initializeConfigPropertiesFiles(this.getClass().getClassLoader(), DISTRIBUTED_MAP_PROPERTIES);
            this.initializeConfigPropertiesFiles(this.getClass().getClassLoader(), CACHE_INSTANCES_PROPERTIES);
            ArrayList instanceList = cacheService.getObjectCacheInstanceNames();
            for (String instanceName : instanceList) {
                CacheConfig cacheConfig = cacheService.getCacheInstanceConfig(instanceName);
                if (cacheConfig == null || !cacheConfig.isCreateCacheAtServerStartup()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create object cache instance \"" + instanceName + "\" during startup because the cache is configured to."), (Object[])new Object[0]);
                }
                ServerCache.createCache(cacheConfig.getCacheName(), cacheConfig);
            }
            Tr.info((TraceComponent)tc, (String)"DYNA1056I", (Object[])new Object[0]);
        }
        catch (IllegalStateException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ObjectCacheServiceImpl.start", (String)"232", (Object)this);
            Tr.error((TraceComponent)tc, (String)"dynacache.cacheInitFailed", (Object[])new Object[]{cacheConfigTemplate.getServerServerName(), ex.getMessage()});
            throw new RuntimeError("Object Cache Service was not initialized sucessful. Exception: " + ex.getMessage());
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ObjectCacheServiceImpl.start", (String)"237", (Object)this);
            Tr.error((TraceComponent)tc, (String)"dynacache.cacheInitFailed", (Object[])new Object[]{cacheConfigTemplate.getServerServerName(), ex.getMessage()});
            throw new RuntimeError("Object Cache Service was not initialized sucessful. Exception: " + ex.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("start() objectCacheEnabled=" + ServerCache.objectCacheEnabled));
        }
    }

    protected void stop() {
        String methodName = "stop()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop()", (Object[])new Object[0]);
        }
        ServerCache.objectCacheEnabled = false;
        CacheService cacheService = this.getCacheService();
        if (null == cacheService) {
            return;
        }
        this.unInitializeConfigPropertiesFiles(this.getClass().getClassLoader(), DISTRIBUTED_MAP_PROPERTIES);
        this.unInitializeConfigPropertiesFiles(this.getClass().getClassLoader(), CACHE_INSTANCES_PROPERTIES);
        Collection<DistributedObjectCache> distributedMaps = DistributedObjectCacheFactory.distributedMaps.values();
        for (DistributedObjectCache distributedObjectCache : distributedMaps) {
            DCache cache = ((DistributedObjectCacheAdapter)distributedObjectCache).getCache();
            ServerCache.getCacheInstances().remove(cache);
            cache.stop();
        }
        DistributedObjectCacheFactory.distributedMaps.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop()");
        }
    }

    public void onStartup(Set<Class<?>> c, ServletContext ctx) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"onStartup", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("created listener to add to servletContext.  listener is: " + this), (Object[])new Object[0]);
        }
        ctx.addListener((EventListener)((Object)this));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onStartup");
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        String methodName = "contextInitialized";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contextInitialized", (Object[])new Object[]{sce.getServletContext().getContextPath()});
        }
        try {
            CacheService cacheService = this.getCacheService();
            if (null == cacheService) {
                return;
            }
            this.initializeConfigPropertiesFiles(sce.getServletContext().getClassLoader(), DISTRIBUTED_MAP_PROPERTIES);
            this.initializeConfigPropertiesFiles(sce.getServletContext().getClassLoader(), CACHE_INSTANCES_PROPERTIES);
            this.initializeConfigPropertiesFiles(sce.getServletContext().getClassLoader(), WEB_INF_DISTRIBUTED_MAP_PROPERTIES);
            this.initializeConfigPropertiesFiles(sce.getServletContext().getClassLoader(), WEB_INF_CACHE_INSTANCES_PROPERTIES);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ObjectCacheServiceImpl.contextInitialized(ServletContextEvent)", (String)"169", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contextInitialized");
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        String methodName = "contextDestroyed";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contextDestroyed", (Object[])new Object[]{sce.getServletContext().getContextPath()});
        }
        try {
            CacheService cacheService = this.getCacheService();
            if (null == cacheService) {
                return;
            }
            this.unInitializeConfigPropertiesFiles(sce.getServletContext().getClassLoader(), DISTRIBUTED_MAP_PROPERTIES);
            this.unInitializeConfigPropertiesFiles(sce.getServletContext().getClassLoader(), CACHE_INSTANCES_PROPERTIES);
            this.unInitializeConfigPropertiesFiles(sce.getServletContext().getClassLoader(), WEB_INF_DISTRIBUTED_MAP_PROPERTIES);
            this.unInitializeConfigPropertiesFiles(sce.getServletContext().getClassLoader(), WEB_INF_CACHE_INSTANCES_PROPERTIES);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ObjectCacheServiceImpl.contextDestroyed(ServletContextEvent)", (String)"184", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contextDestroyed");
        }
    }

    protected void setServerCache(ServerCache serverCache) {
        this.serverCacheReference.set(serverCache);
    }

    protected void unsetServerCache(ServerCache serverCache) {
        this.serverCacheReference.compareAndSet(serverCache, null);
    }

    protected CacheService getCacheService() {
        ServerCache sc = this.serverCacheReference.get();
        if (sc != null) {
            return ServerCache.getCacheService();
        }
        return null;
    }

    protected void setVariableRegistry(VariableRegistry vr) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setVariableRegistry ", (Object[])new Object[]{vr});
        }
        this.variableRegistryRef.set(vr);
    }

    protected void unsetVariableRegistry(VariableRegistry vr) {
        this.variableRegistryRef.compareAndSet(vr, null);
    }

    private void initializeConfigPropertiesFiles(ClassLoader cl, String fileName) {
        String methodName = "initializeConfigPropertiesFiles()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initializeConfigPropertiesFiles() classLoader=" + cl + " fileName=" + fileName), (Object[])new Object[0]);
        }
        try {
            Enumeration<URL> resources = cl.getResources(fileName);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (this.processedUrls.contains(url)) continue;
                this.processConfigUrl(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeConfigPropertiesFiles()");
        }
    }

    private void unInitializeConfigPropertiesFiles(ClassLoader classLoader, String fileName) {
        try {
            Enumeration<URL> resources = classLoader.getResources(fileName);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                this.processedUrls.remove(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConfigUrl(URL url) throws Exception {
        String methodName = "processConfigUrl()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processConfigUrl() configUrl=" + url), (Object[])new Object[0]);
        }
        this.processedUrls.add(url);
        Properties props = new Properties();
        InputStream is = url.openStream();
        try {
            props.load(is);
        }
        finally {
            is.close();
        }
        int i = 0;
        VariableRegistry vr = this.variableRegistryRef.get();
        boolean found = false;
        do {
            String instancekey;
            String instanceName;
            if ((instanceName = props.getProperty(instancekey = "cache.instance." + i)) != null && instanceName.charAt(0) == '/') {
                instanceName = instanceName.substring(1);
            }
            if (instanceName != null) {
                instanceName = instanceName.trim();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processConfigUrl() Adding new cache instance. instanceName=" + instanceName), (Object[])new Object[0]);
                }
                found = true;
                Iterator<Object> it = props.keySet().iterator();
                Properties ccProps = new Properties();
                ccProps.put("com.ibm.ws.cache.CacheConfig.cacheName", instanceName);
                while (it.hasNext()) {
                    String s = (String)it.next();
                    if (!s.startsWith(instancekey + ".")) continue;
                    String value = vr.resolveString(props.getProperty(s)).trim();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processConfigUrl() Adding property: " + s + " value:" + value), (Object[])new Object[0]);
                    }
                    ccProps.put("com.ibm.ws.cache.CacheConfig" + s.substring(instancekey.length()), value);
                    String unmodifiedKey = s.substring(instancekey.length() + 1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processConfigUrl() Adding property: " + unmodifiedKey + " value:" + value), (Object[])new Object[0]);
                    }
                    ccProps.put(unmodifiedKey, value);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processConfigUrl() Final props=" + ccProps), (Object[])new Object[0]);
                }
                DCache c = ServerCache.getCache(instanceName);
                CacheService cs = this.getCacheService();
                CacheConfig cacheConfig = cs.getCacheInstanceConfig(instanceName);
                if (c == null && cacheConfig == null) {
                    cacheConfig = cs.addCacheInstanceConfig(ccProps);
                    if (cacheConfig.isCreateCacheAtServerStartup()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Create cache instance \"" + instanceName + "\" during startup because the cache is configured to."), (Object[])new Object[0]);
                        }
                        ServerCache.createCache(cacheConfig.getCacheName(), cacheConfig);
                    }
                } else {
                    Tr.warning((TraceComponent)tc, (String)"DYNA1057W", (Object[])new Object[]{instanceName, url.toString()});
                }
            } else {
                found = false;
            }
            ++i;
        } while (found);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processConfigUrl() configUrl=" + url));
        }
    }

    static {
        ServerCache.cacheUnit.setObjectCacheUnit(objectCacheUnit);
    }
}

