/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.queue;

import com.ibm.ws.request.timing.queue.QueueableRequest;
import com.ibm.wsspi.requestContext.RequestContext;

public class SlowRequest
extends QueueableRequest {
    private final long slowRequestThreshold;
    private final int slowRequestIterationsReq;
    private volatile int iterationsCompleted;
    private final boolean includeContextInfo;

    public SlowRequest(RequestContext requestContext, long delay, long slowRequestThreshold, boolean includeContextInfo) {
        super(requestContext, delay);
        this.slowRequestThreshold = slowRequestThreshold;
        this.slowRequestIterationsReq = 3;
        this.iterationsCompleted = 0;
        this.includeContextInfo = includeContextInfo;
    }

    public long getSlowRequestThreshold() {
        return this.slowRequestThreshold;
    }

    public int getSlowRequestIterationsReq() {
        return this.slowRequestIterationsReq;
    }

    public int getIterationsCompleted() {
        return this.iterationsCompleted;
    }

    public int incIterationCount() {
        return ++this.iterationsCompleted;
    }

    public boolean includeContextInfo() {
        return this.includeContextInfo;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        StringBuffer slowReq = new StringBuffer();
        slowReq.append(String.format("%n", new Object[0]));
        if (this.getInitialDelay() == this.slowRequestThreshold) {
            slowReq.append("-----------------------Slow Request Details-------------------------" + String.format("%n", new Object[0]));
        } else {
            slowReq.append("-------------------Probable Slow Request Details-------------------" + String.format("%n", new Object[0]));
        }
        slowReq.append("Request Id : " + this.getRequestContext().getRequestId().getId() + String.format("%n", new Object[0]));
        slowReq.append("Request type : " + this.getRequestContext().getRootEvent().getType() + String.format("%n", new Object[0]));
        slowReq.append("Request state : " + this.getRequestContext().getRequestState() + String.format("%n", new Object[0]));
        slowReq.append("Iterations completed : " + this.getIterationsCompleted() + String.format("%n", new Object[0]));
        slowReq.append("Initial Delay (ms) : " + this.getInitialDelay() + String.format("%n", new Object[0]));
        slowReq.append("Slow request threshold mean (ms) : " + this.slowRequestThreshold + String.format("%n", new Object[0]));
        slowReq.append("Include Context Info : " + this.includeContextInfo + String.format("%n", new Object[0]));
        slowReq.append("-----------------------------------------------------------------------");
        return slowReq.toString();
    }
}

