/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.java;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.internal.Parser;
import com.ibm.json.java.internal.Serializer;
import com.ibm.json.java.internal.SerializerVerbose;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;

public class JSONObject
extends HashMap
implements JSONArtifact {
    private static final long serialVersionUID = -3269263069889337298L;

    public static boolean isValidObject(Object object) {
        if (null == object) {
            return true;
        }
        return JSONObject.isValidType(object.getClass());
    }

    public static boolean isValidType(Class clazz) {
        if (null == clazz) {
            throw new IllegalArgumentException();
        }
        if (String.class == clazz) {
            return true;
        }
        if (Boolean.class == clazz) {
            return true;
        }
        if (JSONObject.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (JSONArray.class == clazz) {
            return true;
        }
        return Number.class.isAssignableFrom(clazz);
    }

    public static JSONObject parse(Reader reader) throws IOException {
        return new Parser(reader).parse();
    }

    public static JSONObject parse(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        return JSONObject.parse(stringReader);
    }

    public static JSONObject parse(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (Exception exception) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        return JSONObject.parse(inputStreamReader);
    }

    public void serialize(OutputStream outputStream) throws IOException {
        this.serialize(outputStream, false);
    }

    public void serialize(OutputStream outputStream, boolean bl) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IOException iOException = new IOException(unsupportedEncodingException.toString());
            iOException.initCause(unsupportedEncodingException);
            throw iOException;
        }
        this.serialize(bufferedWriter, bl);
    }

    public void serialize(Writer writer) throws IOException {
        this.serialize(writer, false);
    }

    public void serialize(Writer writer, boolean bl) throws IOException {
        Class<?> clazz;
        if (!(StringWriter.class.isAssignableFrom(clazz = writer.getClass()) || CharArrayWriter.class.isAssignableFrom(clazz) || BufferedWriter.class.isAssignableFrom(clazz))) {
            writer = new BufferedWriter(writer);
        }
        Object object = bl ? new SerializerVerbose(writer) : new Serializer(writer);
        object.writeObject(this).flush();
    }

    public String serialize(boolean bl) throws IOException {
        StringWriter stringWriter = new StringWriter();
        Object object = bl ? new SerializerVerbose((Writer)stringWriter) : new Serializer((Writer)stringWriter);
        object.writeObject(this).flush();
        return stringWriter.toString();
    }

    public String serialize() throws IOException {
        return this.serialize(false);
    }

    public Object put(Object object, Object object2) {
        if (null == object) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (!JSONObject.isValidObject(object2)) {
            if (object2 != null) {
                throw new IllegalArgumentException("Invalid type of value.  Type: [" + object2.getClass().getName() + "] with value: [" + object2.toString() + "]");
            }
            throw new IllegalArgumentException("Invalid type of value.");
        }
        return super.put(object, object2);
    }

    public String toString() {
        String string = null;
        try {
            string = this.serialize(false);
        }
        catch (IOException iOException) {
            string = "JSON Generation Error: [" + iOException.toString() + "]";
        }
        return string;
    }
}

