/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.jaxrs.server;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs.configuration.IBMDeploymentConfiguration;
import com.ibm.ws.jaxrs.webcontainer.JAXRSDefaultApplicationSubclassProxy;
import com.ibm.ws.jaxrs.webcontainer.JAXRSHttpServletRequestAdapter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.utils.ClassUtils;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.apache.wink.server.internal.RequestProcessor;
import org.apache.wink.server.internal.application.ServletWinkApplication;
import org.apache.wink.server.internal.servlet.RestServlet;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class IBMRestServlet
extends RestServlet {
    private static final long serialVersionUID = 3701186365876887528L;
    private static final TraceComponent tc = Tr.register(IBMRestServlet.class, (String)"JAXRS", (String)"com.ibm.ws.jaxrs.internal.resources.JAXRSMessages");
    private final String requestProcessAttribute;
    private final Class<?> applicationSubclass;
    private final Set<Class<?>> scannedClasses;

    public IBMRestServlet() {
        this.requestProcessAttribute = null;
        this.applicationSubclass = null;
        this.scannedClasses = null;
    }

    public IBMRestServlet(Class<?> applicationSubclass, Set<Class<?>> scannedClasses, String requestProcessAttribute) {
        if (requestProcessAttribute == null || "".equals(requestProcessAttribute)) {
            throw new IllegalArgumentException();
        }
        this.requestProcessAttribute = RequestProcessor.class.getName() + "#" + requestProcessAttribute;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("IBMRestServlet:  setting application subclass to " + applicationSubclass), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("IBMRestServlet:  setting request processor attribute to " + this.requestProcessAttribute), (Object[])new Object[0]);
        }
        this.applicationSubclass = applicationSubclass;
        this.scannedClasses = scannedClasses;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        IWebAppNameSpaceCollaborator collaborator = null;
        collaborator = (IWebAppNameSpaceCollaborator)this.getServletContext().getAttribute("collaborator");
        if (collaborator != null) {
            ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            httpServletRequest = new JAXRSHttpServletRequestAdapter(httpServletRequest, collaborator, componentMetaData);
        }
        RequestProcessor reqProc = this.getRequestProcessor();
        reqProc.handleRequest(httpServletRequest, httpServletResponse);
    }

    @ManualTrace
    protected RequestProcessor getRequestProcessor() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRequestProcessor", (Object[])new Object[0]);
        }
        RequestProcessor reqProcessor = null;
        if (this.requestProcessAttribute == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"requestProcessorAttribute was null so getting the RequestProcessor from the normal Wink method", (Object[])new Object[0]);
            }
            reqProcessor = super.getRequestProcessor();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"requestProcessorAttribute was set to {0} so getting the RequestProcessor from the servlet context", (Object[])new Object[]{this.requestProcessAttribute});
            }
            reqProcessor = RequestProcessor.getRequestProcessor((ServletContext)this.getServletContext(), (String)(RequestProcessor.class.getName() + this.requestProcessAttribute));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRequestProcessor", (Object)new Object[]{reqProcessor});
        }
        return reqProcessor;
    }

    @ManualTrace
    protected void storeRequestProcessorOnServletContext(RequestProcessor requestProcessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"storeRequestProcessorOnServletContext", (Object[])new Object[]{requestProcessor});
        }
        if (this.requestProcessAttribute == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"requestProcessorAttribute was null so storing the RequestProcessor via the normal Wink method", (Object[])new Object[0]);
            }
            super.storeRequestProcessorOnServletContext(requestProcessor);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"requestProcessorAttribute was set to {0} so storing the RequestProcessor using that key to the servlet context", (Object[])new Object[]{RequestProcessor.class.getName() + this.requestProcessAttribute});
            }
            requestProcessor.storeRequestProcessorOnServletContext(this.getServletContext(), RequestProcessor.class.getName() + this.requestProcessAttribute);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"storeRequestProcessorOnServletContext", (Object)new Object[]{requestProcessor});
        }
    }

    Application _getApplication(DeploymentConfiguration configuration) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        return this.getApplication(configuration);
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    protected Application getApplication(DeploymentConfiguration configuration) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Application appInstance;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getApplication", (Object[])new Object[]{configuration});
            }
            appInstance = null;
            if (this.applicationSubclass != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Application subclass was not null so going to use ObjectFactories to create it in case it is not a normal class (i.e. EJB/JCDI bean)", (Object[])new Object[0]);
                }
                try {
                    ObjectFactory of = configuration.getOfFactoryRegistry().getObjectFactory(this.applicationSubclass);
                    configuration.addApplicationObjectFactory(of);
                    appInstance = (Application)of.getInstance(null);
                }
                catch (ClassCastException of) {
                    FFDCFilter.processException((Throwable)of, (String)"com.ibm.websphere.jaxrs.server.IBMRestServlet", (String)"208", (Object)((Object)this), (Object[])new Object[]{configuration});
                    if (tc.isErrorEnabled()) {
                        void e;
                        Tr.error((TraceComponent)tc, (String)"exceptionInstantiatingAppSubclass", (Object[])new Object[]{this.applicationSubclass.getName(), e});
                    }
                    if (!tc.isEntryEnabled()) break block14;
                    Tr.entry((TraceComponent)tc, (String)"getApplication", (Object[])new Object[]{false});
                }
            }
        }
        if (appInstance == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Retrieving the application instance via normal Wink methods ", (Object[])new Object[0]);
            }
            Class appClass = null;
            ServletConfig servletConfig = configuration.getServletConfig();
            String initParameter = servletConfig.getInitParameter("javax.ws.rs.Application");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"init-param {0} was set to {1}", (Object[])new Object[]{"javax.ws.rs.Application", initParameter});
            }
            if (initParameter != null) {
                appClass = ClassUtils.loadClass((String)initParameter);
                ObjectFactory of = configuration.getOfFactoryRegistry().getObjectFactory(appClass);
                configuration.addApplicationObjectFactory(of);
                appInstance = (Application)of.getInstance(null);
            } else {
                String appLocationParameter = servletConfig.getInitParameter("applicationConfigLocation");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"init-param {0} was set to {1}", (Object[])new Object[]{"applicationConfigLocation", appLocationParameter});
                }
                if (appLocationParameter != null) {
                    appInstance = new ServletWinkApplication(this.getServletContext(), appLocationParameter);
                }
            }
        }
        JAXRSDefaultApplicationSubclassProxy proxy = new JAXRSDefaultApplicationSubclassProxy(appInstance, this.scannedClasses);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getApplication", (Object)new Object[]{proxy});
        }
        return proxy;
    }

    protected DeploymentConfiguration createDeploymentConfiguration() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String initParameter = this.getInitParameter("deploymentConfiguration");
        if (initParameter != null) {
            if (tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"restServletUseDeploymentConfigurationParam", (Object[])new Object[]{initParameter, "deploymentConfiguration"});
            }
            Class confClass = ClassUtils.loadClass((String)initParameter);
            return (DeploymentConfiguration)confClass.newInstance();
        }
        return new IBMDeploymentConfiguration(this.getServletContext());
    }
}

