/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader.filters;

import com.ibm.websphere.logging.hpel.reader.LogQueryBean;
import com.ibm.websphere.logging.hpel.reader.LogRecordFilter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class LogViewerFilter
implements LogRecordFilter {
    private static final String CLASS_NAME = LogViewerFilter.class.getName();
    private static final Logger log = Logger.getLogger(CLASS_NAME);
    private Level minLevel;
    private Level maxLevel;
    private Date startDate;
    private Date stopDate;
    private String includeLoggers;
    private String excludeLoggers;
    private String[] inLoggers;
    private String[] exLoggers;
    private int intThreadID;
    private Pattern messageRegExp;
    private final List<String> includeExtensionRegExpKeys;
    private final List<Pattern> includeExtensionRegExpPatterns;
    private boolean filterLevel;
    private boolean filterTime;
    private boolean filterLoggers;
    private boolean filterThread;
    private boolean filterMessage;
    private final Extension[] extensions;

    public LogViewerFilter(Date startDate, Date stopDate, Level minLevel, Level maxLevel, String includeLoggers, String excludeLoggers, String threadID, String message, List<Extension> extensions) {
        block21: {
            this.minLevel = null;
            this.maxLevel = null;
            this.startDate = null;
            this.stopDate = null;
            this.includeLoggers = null;
            this.excludeLoggers = null;
            this.inLoggers = null;
            this.exLoggers = null;
            this.intThreadID = 0;
            this.includeExtensionRegExpKeys = new ArrayList<String>();
            this.includeExtensionRegExpPatterns = new ArrayList<Pattern>();
            this.filterLevel = false;
            this.filterTime = false;
            this.filterLoggers = false;
            this.filterThread = false;
            this.filterMessage = false;
            String methodName = "<init>";
            if (startDate != null || stopDate != null) {
                if (startDate != null) {
                    this.startDate = (Date)startDate.clone();
                }
                if (stopDate != null) {
                    this.stopDate = (Date)stopDate.clone();
                }
                this.filterTime = true;
            }
            if (minLevel != null || maxLevel != null) {
                if (minLevel != null) {
                    this.minLevel = minLevel;
                }
                if (maxLevel != null) {
                    this.maxLevel = maxLevel;
                }
                this.filterLevel = true;
            }
            if (includeLoggers != null || excludeLoggers != null) {
                int i;
                if (includeLoggers != null) {
                    this.includeLoggers = includeLoggers;
                    this.inLoggers = includeLoggers.split(",");
                    for (i = 0; i < this.inLoggers.length; ++i) {
                        this.inLoggers[i] = this.inLoggers[i].trim();
                    }
                }
                if (excludeLoggers != null) {
                    this.excludeLoggers = excludeLoggers;
                    this.exLoggers = excludeLoggers.split(",");
                    for (i = 0; i < this.exLoggers.length; ++i) {
                        this.exLoggers[i] = this.exLoggers[i].trim();
                    }
                }
                this.filterLoggers = true;
            }
            if (threadID != null) {
                try {
                    this.intThreadID = Integer.parseInt(threadID, 16);
                    this.filterThread = true;
                }
                catch (NumberFormatException e) {
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, methodName, "Unable to parse thread ID. Filtering by thread is disabled");
                    }
                    this.filterThread = false;
                }
            }
            if (message != null) {
                try {
                    this.messageRegExp = this.getRegularExpression(message);
                    this.filterMessage = true;
                }
                catch (IllegalArgumentException ae) {
                    if (!log.isLoggable(Level.FINE)) break block21;
                    log.logp(Level.FINE, CLASS_NAME, methodName, "The message option " + message + " contains an invalid expession. The message filtering is disabled.");
                }
            }
        }
        if (extensions != null && extensions.size() > 0) {
            for (Extension ext : this.extensions = extensions.toArray(new Extension[extensions.size()])) {
                this.includeExtensionRegExpKeys.add(ext.key);
                this.includeExtensionRegExpPatterns.add(this.getRegularExpression(ext.value));
            }
        } else {
            this.extensions = null;
        }
    }

    @Override
    public boolean accept(RepositoryLogRecord record) {
        if (this.filterThread && this.intThreadID != record.getThreadID()) {
            return false;
        }
        if (this.filterLevel) {
            if (this.minLevel != null && record.getLevel().intValue() < this.minLevel.intValue()) {
                return false;
            }
            if (this.maxLevel != null && record.getLevel().intValue() > this.maxLevel.intValue()) {
                return false;
            }
        }
        if (this.filterTime) {
            Date recordDate = new Date();
            recordDate.setTime(record.getMillis());
            if (this.startDate != null && recordDate.before(this.startDate)) {
                return false;
            }
            if (this.stopDate != null && recordDate.after(this.stopDate)) {
                return false;
            }
        }
        if (this.filterLoggers) {
            int tmpInt;
            int excludeMatchLevel = -1;
            int includeMatchLevel = -1;
            if (this.excludeLoggers != null) {
                for (String x : this.exLoggers) {
                    if (record.getLoggerName() == null || !record.getLoggerName().matches(x.replace("*", ".*")) || (tmpInt = x.split("\\.").length) <= excludeMatchLevel) continue;
                    excludeMatchLevel = tmpInt;
                }
            } else {
                excludeMatchLevel = 0;
            }
            if (this.includeLoggers != null) {
                for (String x : this.inLoggers) {
                    if (record.getLoggerName() == null || !record.getLoggerName().matches(x.replace("*", ".*")) || (tmpInt = x.split("\\.").length) <= includeMatchLevel) continue;
                    includeMatchLevel = tmpInt;
                }
            } else {
                includeMatchLevel = 0;
            }
            if (this.includeLoggers == null) {
                // empty if block
            }
            if (includeMatchLevel <= excludeMatchLevel) {
                return false;
            }
        }
        if (this.filterMessage) {
            String recordMessage;
            String string = recordMessage = record.getFormattedMessage() != null ? record.getFormattedMessage() : record.getRawMessage();
            if (recordMessage == null) {
                return false;
            }
            boolean foundmessagekey = this.messageRegExp.matcher(recordMessage = recordMessage.replace("\n", "").replace("\r", "")).find();
            if (!foundmessagekey) {
                return false;
            }
        }
        if (this.extensions != null) {
            boolean match = false;
            for (Extension extension : this.extensions) {
                String value = record.getExtension(extension.key);
                if (value == null || extension.value != null && !this.includeExtensionRegExpPatterns.get(this.includeExtensionRegExpKeys.indexOf(extension.key)).matcher(value).find()) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        return true;
    }

    private Pattern getRegularExpression(String rawString) throws IllegalArgumentException {
        return LogQueryBean.compile(rawString);
    }

    public static final class Extension {
        final String key;
        final String value;

        public Extension(StringBuilder key, StringBuilder value) throws IllegalArgumentException {
            if (value == null) {
                throw new IllegalArgumentException("Value can not be 'null'");
            }
            if (key == null) {
                this.key = value.toString();
                this.value = null;
            } else {
                this.key = key.toString();
                this.value = value.toString();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.key).append("=").append(this.value);
            return sb.toString();
        }
    }
}

