/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.registry;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.intfc.WSSecurityService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.List;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RegistryHelper {
    private static final TraceComponent tc = Tr.register(RegistryHelper.class, null, null);
    private static final AtomicServiceReference<WSSecurityService> wsSecurityServiceRef = new AtomicServiceReference("wsSecurityService");
    static final long serialVersionUID = -5747498841828353527L;

    public void setWsSecurityService(ServiceReference<WSSecurityService> reference) {
        wsSecurityServiceRef.setReference(reference);
    }

    public void unsetWsSecurityService(ServiceReference<WSSecurityService> reference) {
        wsSecurityServiceRef.unsetReference(reference);
    }

    public void activate(ComponentContext cc) {
        wsSecurityServiceRef.activate(cc);
    }

    public void deactivate(ComponentContext cc) {
        wsSecurityServiceRef.deactivate(cc);
    }

    /*
     * WARNING - void declaration
     */
    public static UserRegistry getUserRegistry(String realmName) throws WSSecurityException {
        block5: {
            try {
                WSSecurityService ss = (WSSecurityService)wsSecurityServiceRef.getService();
                if (ss == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No WSSecurityService, returning null", (Object[])new Object[0]);
                    }
                    break block5;
                }
                return ss.getUserRegistry(realmName);
            }
            catch (WSSecurityException ss) {
                void e;
                FFDCFilter.processException((Throwable)ss, (String)"com.ibm.wsspi.security.registry.RegistryHelper", (String)"75", null, (Object[])new Object[]{realmName});
                String msg = "getUserRegistry for realm " + realmName + " failed due to an internal error: " + e.getMessage();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[]{e});
                }
                throw new WSSecurityException(msg, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getInboundTrustedRealms(String realmName) throws WSSecurityException {
        block5: {
            try {
                WSSecurityService ss = (WSSecurityService)wsSecurityServiceRef.getService();
                if (ss == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No WSSecurityService, returning null", (Object[])new Object[0]);
                    }
                    break block5;
                }
                return ss.getInboundTrustedRealms(realmName);
            }
            catch (WSSecurityException ss) {
                void e;
                FFDCFilter.processException((Throwable)ss, (String)"com.ibm.wsspi.security.registry.RegistryHelper", (String)"111", null, (Object[])new Object[]{realmName});
                String msg = "Failed due to an internal error: " + e.getMessage();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[]{e});
                }
                throw new WSSecurityException(msg, (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isRealmInboundTrusted(String inboundRealm, String localRealm) {
        WSSecurityService ss = (WSSecurityService)wsSecurityServiceRef.getService();
        if (ss == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No WSSecurityService, returning true", (Object[])new Object[0]);
            }
            return true;
        }
        return ss.isRealmInboundTrusted(inboundRealm, localRealm);
    }
}

