/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class TrainLanguageModelOptions
extends GenericModel {
    protected String customizationId;
    protected String wordTypeToAdd;
    protected Double customizationWeight;
    protected Boolean strict;

    protected TrainLanguageModelOptions() {
    }

    protected TrainLanguageModelOptions(Builder builder) {
        Validator.notEmpty((String)builder.customizationId, (String)"customizationId cannot be empty");
        this.customizationId = builder.customizationId;
        this.wordTypeToAdd = builder.wordTypeToAdd;
        this.customizationWeight = builder.customizationWeight;
        this.strict = builder.strict;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String wordTypeToAdd() {
        return this.wordTypeToAdd;
    }

    public Double customizationWeight() {
        return this.customizationWeight;
    }

    public Boolean strict() {
        return this.strict;
    }

    public static class Builder {
        private String customizationId;
        private String wordTypeToAdd;
        private Double customizationWeight;
        private Boolean strict;

        private Builder(TrainLanguageModelOptions trainLanguageModelOptions) {
            this.customizationId = trainLanguageModelOptions.customizationId;
            this.wordTypeToAdd = trainLanguageModelOptions.wordTypeToAdd;
            this.customizationWeight = trainLanguageModelOptions.customizationWeight;
            this.strict = trainLanguageModelOptions.strict;
        }

        public Builder() {
        }

        public Builder(String customizationId) {
            this.customizationId = customizationId;
        }

        public TrainLanguageModelOptions build() {
            return new TrainLanguageModelOptions(this);
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder wordTypeToAdd(String wordTypeToAdd) {
            this.wordTypeToAdd = wordTypeToAdd;
            return this;
        }

        public Builder customizationWeight(Double customizationWeight) {
            this.customizationWeight = customizationWeight;
            return this;
        }

        public Builder strict(Boolean strict) {
            this.strict = strict;
            return this;
        }
    }

    public static interface WordTypeToAdd {
        public static final String ALL = "all";
        public static final String USER = "user";
    }
}

