/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class QueryLargeSimilar
extends GenericModel {
    protected Boolean enabled;
    @SerializedName(value="document_ids")
    protected List<String> documentIds;
    protected List<String> fields;

    protected QueryLargeSimilar() {
    }

    protected QueryLargeSimilar(Builder builder) {
        this.enabled = builder.enabled;
        this.documentIds = builder.documentIds;
        this.fields = builder.fields;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<String> documentIds() {
        return this.documentIds;
    }

    public List<String> fields() {
        return this.fields;
    }

    public static class Builder {
        private Boolean enabled;
        private List<String> documentIds;
        private List<String> fields;

        private Builder(QueryLargeSimilar queryLargeSimilar) {
            this.enabled = queryLargeSimilar.enabled;
            this.documentIds = queryLargeSimilar.documentIds;
            this.fields = queryLargeSimilar.fields;
        }

        public Builder() {
        }

        public QueryLargeSimilar build() {
            return new QueryLargeSimilar(this);
        }

        public Builder addDocumentIds(String documentIds) {
            Validator.notNull((Object)documentIds, (String)"documentIds cannot be null");
            if (this.documentIds == null) {
                this.documentIds = new ArrayList<String>();
            }
            this.documentIds.add(documentIds);
            return this;
        }

        public Builder addFields(String fields) {
            Validator.notNull((Object)fields, (String)"fields cannot be null");
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(fields);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder documentIds(List<String> documentIds) {
            this.documentIds = documentIds;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }
    }
}

