/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class GetDocumentOptions
extends GenericModel {
    protected String projectId;
    protected String collectionId;
    protected String documentId;

    protected GetDocumentOptions() {
    }

    protected GetDocumentOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.notEmpty((String)builder.documentId, (String)"documentId cannot be empty");
        this.projectId = builder.projectId;
        this.collectionId = builder.collectionId;
        this.documentId = builder.documentId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String documentId() {
        return this.documentId;
    }

    public static class Builder {
        private String projectId;
        private String collectionId;
        private String documentId;

        private Builder(GetDocumentOptions getDocumentOptions) {
            this.projectId = getDocumentOptions.projectId;
            this.collectionId = getDocumentOptions.collectionId;
            this.documentId = getDocumentOptions.documentId;
        }

        public Builder() {
        }

        public Builder(String projectId, String collectionId, String documentId) {
            this.projectId = projectId;
            this.collectionId = collectionId;
            this.documentId = documentId;
        }

        public GetDocumentOptions build() {
            return new GetDocumentOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }
    }
}

