/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.discovery.v2.model.AddDocumentOptions;
import com.ibm.watson.discovery.v2.model.AnalyzeDocumentOptions;
import com.ibm.watson.discovery.v2.model.AnalyzedDocument;
import com.ibm.watson.discovery.v2.model.CollectionDetails;
import com.ibm.watson.discovery.v2.model.Completions;
import com.ibm.watson.discovery.v2.model.ComponentSettingsResponse;
import com.ibm.watson.discovery.v2.model.CreateCollectionOptions;
import com.ibm.watson.discovery.v2.model.CreateDocumentClassifierModelOptions;
import com.ibm.watson.discovery.v2.model.CreateDocumentClassifierOptions;
import com.ibm.watson.discovery.v2.model.CreateEnrichmentOptions;
import com.ibm.watson.discovery.v2.model.CreateExpansionsOptions;
import com.ibm.watson.discovery.v2.model.CreateProjectOptions;
import com.ibm.watson.discovery.v2.model.CreateStopwordListOptions;
import com.ibm.watson.discovery.v2.model.CreateTrainingQueryOptions;
import com.ibm.watson.discovery.v2.model.DeleteCollectionOptions;
import com.ibm.watson.discovery.v2.model.DeleteDocumentClassifierModelOptions;
import com.ibm.watson.discovery.v2.model.DeleteDocumentClassifierOptions;
import com.ibm.watson.discovery.v2.model.DeleteDocumentOptions;
import com.ibm.watson.discovery.v2.model.DeleteDocumentResponse;
import com.ibm.watson.discovery.v2.model.DeleteEnrichmentOptions;
import com.ibm.watson.discovery.v2.model.DeleteExpansionsOptions;
import com.ibm.watson.discovery.v2.model.DeleteProjectOptions;
import com.ibm.watson.discovery.v2.model.DeleteStopwordListOptions;
import com.ibm.watson.discovery.v2.model.DeleteTrainingQueriesOptions;
import com.ibm.watson.discovery.v2.model.DeleteTrainingQueryOptions;
import com.ibm.watson.discovery.v2.model.DeleteUserDataOptions;
import com.ibm.watson.discovery.v2.model.DocumentAccepted;
import com.ibm.watson.discovery.v2.model.DocumentClassifier;
import com.ibm.watson.discovery.v2.model.DocumentClassifierModel;
import com.ibm.watson.discovery.v2.model.DocumentClassifierModels;
import com.ibm.watson.discovery.v2.model.DocumentClassifiers;
import com.ibm.watson.discovery.v2.model.DocumentDetails;
import com.ibm.watson.discovery.v2.model.Enrichment;
import com.ibm.watson.discovery.v2.model.Enrichments;
import com.ibm.watson.discovery.v2.model.Expansions;
import com.ibm.watson.discovery.v2.model.GetAutocompletionOptions;
import com.ibm.watson.discovery.v2.model.GetCollectionOptions;
import com.ibm.watson.discovery.v2.model.GetComponentSettingsOptions;
import com.ibm.watson.discovery.v2.model.GetDocumentClassifierModelOptions;
import com.ibm.watson.discovery.v2.model.GetDocumentClassifierOptions;
import com.ibm.watson.discovery.v2.model.GetDocumentOptions;
import com.ibm.watson.discovery.v2.model.GetEnrichmentOptions;
import com.ibm.watson.discovery.v2.model.GetProjectOptions;
import com.ibm.watson.discovery.v2.model.GetStopwordListOptions;
import com.ibm.watson.discovery.v2.model.GetTrainingQueryOptions;
import com.ibm.watson.discovery.v2.model.ListCollectionsOptions;
import com.ibm.watson.discovery.v2.model.ListCollectionsResponse;
import com.ibm.watson.discovery.v2.model.ListDocumentClassifierModelsOptions;
import com.ibm.watson.discovery.v2.model.ListDocumentClassifiersOptions;
import com.ibm.watson.discovery.v2.model.ListDocumentsOptions;
import com.ibm.watson.discovery.v2.model.ListDocumentsResponse;
import com.ibm.watson.discovery.v2.model.ListEnrichmentsOptions;
import com.ibm.watson.discovery.v2.model.ListExpansionsOptions;
import com.ibm.watson.discovery.v2.model.ListFieldsOptions;
import com.ibm.watson.discovery.v2.model.ListFieldsResponse;
import com.ibm.watson.discovery.v2.model.ListProjectsOptions;
import com.ibm.watson.discovery.v2.model.ListProjectsResponse;
import com.ibm.watson.discovery.v2.model.ListTrainingQueriesOptions;
import com.ibm.watson.discovery.v2.model.ProjectDetails;
import com.ibm.watson.discovery.v2.model.QueryCollectionNoticesOptions;
import com.ibm.watson.discovery.v2.model.QueryNoticesOptions;
import com.ibm.watson.discovery.v2.model.QueryNoticesResponse;
import com.ibm.watson.discovery.v2.model.QueryOptions;
import com.ibm.watson.discovery.v2.model.QueryResponse;
import com.ibm.watson.discovery.v2.model.StopWordList;
import com.ibm.watson.discovery.v2.model.TrainingQuery;
import com.ibm.watson.discovery.v2.model.TrainingQuerySet;
import com.ibm.watson.discovery.v2.model.UpdateCollectionOptions;
import com.ibm.watson.discovery.v2.model.UpdateDocumentClassifierModelOptions;
import com.ibm.watson.discovery.v2.model.UpdateDocumentClassifierOptions;
import com.ibm.watson.discovery.v2.model.UpdateDocumentOptions;
import com.ibm.watson.discovery.v2.model.UpdateEnrichmentOptions;
import com.ibm.watson.discovery.v2.model.UpdateProjectOptions;
import com.ibm.watson.discovery.v2.model.UpdateTrainingQueryOptions;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class Discovery
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "discovery";
    public static final String DEFAULT_SERVICE_URL = "https://api.us-south.discovery.watson.cloud.ibm.com";
    private String version;

    public Discovery(String version) {
        this(version, DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public Discovery(String version, Authenticator authenticator) {
        this(version, DEFAULT_SERVICE_NAME, authenticator);
    }

    public Discovery(String version, String serviceName) {
        this(version, serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public Discovery(String version, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.setVersion(version);
        this.configureService(serviceName);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Validator.notEmpty((String)version, (String)"version cannot be empty.");
        this.version = version;
    }

    public ServiceCall<ListProjectsResponse> listProjects(ListProjectsOptions listProjectsOptions) {
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listProjects");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListProjectsResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListProjectsResponse> listProjects() {
        return this.listProjects(null);
    }

    public ServiceCall<ProjectDetails> createProject(CreateProjectOptions createProjectOptions) {
        Validator.notNull((Object)((Object)createProjectOptions), (String)"createProjectOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createProject");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createProjectOptions.name());
        contentJson.addProperty("type", createProjectOptions.type());
        if (createProjectOptions.defaultQueryParameters() != null) {
            contentJson.add("default_query_parameters", GsonSingleton.getGson().toJsonTree((Object)createProjectOptions.defaultQueryParameters()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ProjectDetails>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ProjectDetails> getProject(GetProjectOptions getProjectOptions) {
        Validator.notNull((Object)((Object)getProjectOptions), (String)"getProjectOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getProjectOptions.projectId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getProject");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ProjectDetails>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ProjectDetails> updateProject(UpdateProjectOptions updateProjectOptions) {
        Validator.notNull((Object)((Object)updateProjectOptions), (String)"updateProjectOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateProjectOptions.projectId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateProject");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (updateProjectOptions.name() != null) {
            contentJson.addProperty("name", updateProjectOptions.name());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ProjectDetails>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteProject(DeleteProjectOptions deleteProjectOptions) {
        Validator.notNull((Object)((Object)deleteProjectOptions), (String)"deleteProjectOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteProjectOptions.projectId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteProject");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListFieldsResponse> listFields(ListFieldsOptions listFieldsOptions) {
        Validator.notNull((Object)((Object)listFieldsOptions), (String)"listFieldsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listFieldsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/fields", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listFields");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listFieldsOptions.collectionIds() != null) {
            builder.query(new Object[]{"collection_ids", RequestUtils.join(listFieldsOptions.collectionIds(), (String)",")});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListFieldsResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListCollectionsResponse> listCollections(ListCollectionsOptions listCollectionsOptions) {
        Validator.notNull((Object)((Object)listCollectionsOptions), (String)"listCollectionsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listCollectionsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listCollections");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListCollectionsResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CollectionDetails> createCollection(CreateCollectionOptions createCollectionOptions) {
        Validator.notNull((Object)((Object)createCollectionOptions), (String)"createCollectionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createCollectionOptions.projectId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createCollectionOptions.name());
        if (createCollectionOptions.description() != null) {
            contentJson.addProperty("description", createCollectionOptions.description());
        }
        if (createCollectionOptions.language() != null) {
            contentJson.addProperty("language", createCollectionOptions.language());
        }
        if (createCollectionOptions.enrichments() != null) {
            contentJson.add("enrichments", GsonSingleton.getGson().toJsonTree(createCollectionOptions.enrichments()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CollectionDetails>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CollectionDetails> getCollection(GetCollectionOptions getCollectionOptions) {
        Validator.notNull((Object)((Object)getCollectionOptions), (String)"getCollectionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getCollectionOptions.projectId());
        pathParamsMap.put("collection_id", getCollectionOptions.collectionId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CollectionDetails>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CollectionDetails> updateCollection(UpdateCollectionOptions updateCollectionOptions) {
        Validator.notNull((Object)((Object)updateCollectionOptions), (String)"updateCollectionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateCollectionOptions.projectId());
        pathParamsMap.put("collection_id", updateCollectionOptions.collectionId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (updateCollectionOptions.name() != null) {
            contentJson.addProperty("name", updateCollectionOptions.name());
        }
        if (updateCollectionOptions.description() != null) {
            contentJson.addProperty("description", updateCollectionOptions.description());
        }
        if (updateCollectionOptions.enrichments() != null) {
            contentJson.add("enrichments", GsonSingleton.getGson().toJsonTree(updateCollectionOptions.enrichments()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CollectionDetails>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteCollection(DeleteCollectionOptions deleteCollectionOptions) {
        Validator.notNull((Object)((Object)deleteCollectionOptions), (String)"deleteCollectionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteCollectionOptions.projectId());
        pathParamsMap.put("collection_id", deleteCollectionOptions.collectionId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListDocumentsResponse> listDocuments(ListDocumentsOptions listDocumentsOptions) {
        Validator.notNull((Object)((Object)listDocumentsOptions), (String)"listDocumentsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listDocumentsOptions.projectId());
        pathParamsMap.put("collection_id", listDocumentsOptions.collectionId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/documents", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listDocuments");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listDocumentsOptions.count() != null) {
            builder.query(new Object[]{"count", String.valueOf(listDocumentsOptions.count())});
        }
        if (listDocumentsOptions.status() != null) {
            builder.query(new Object[]{"status", String.valueOf(listDocumentsOptions.status())});
        }
        if (listDocumentsOptions.hasNotices() != null) {
            builder.query(new Object[]{"has_notices", String.valueOf(listDocumentsOptions.hasNotices())});
        }
        if (listDocumentsOptions.isParent() != null) {
            builder.query(new Object[]{"is_parent", String.valueOf(listDocumentsOptions.isParent())});
        }
        if (listDocumentsOptions.parentDocumentId() != null) {
            builder.query(new Object[]{"parent_document_id", String.valueOf(listDocumentsOptions.parentDocumentId())});
        }
        if (listDocumentsOptions.sha256() != null) {
            builder.query(new Object[]{"sha256", String.valueOf(listDocumentsOptions.sha256())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListDocumentsResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentAccepted> addDocument(AddDocumentOptions addDocumentOptions) {
        Validator.notNull((Object)((Object)addDocumentOptions), (String)"addDocumentOptions cannot be null");
        Validator.isTrue((addDocumentOptions.file() != null || addDocumentOptions.metadata() != null ? 1 : 0) != 0, (String)"At least one of file or metadata must be supplied.");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", addDocumentOptions.projectId());
        pathParamsMap.put("collection_id", addDocumentOptions.collectionId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/documents", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"addDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (addDocumentOptions.xWatsonDiscoveryForce() != null) {
            builder.header(new Object[]{"X-Watson-Discovery-Force", addDocumentOptions.xWatsonDiscoveryForce()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (addDocumentOptions.file() != null) {
            RequestBody fileBody = RequestUtils.inputStreamBody((InputStream)addDocumentOptions.file(), (String)addDocumentOptions.fileContentType());
            multipartBuilder.addFormDataPart("file", addDocumentOptions.filename(), fileBody);
        }
        if (addDocumentOptions.metadata() != null) {
            multipartBuilder.addFormDataPart("metadata", addDocumentOptions.metadata());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentAccepted>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentDetails> getDocument(GetDocumentOptions getDocumentOptions) {
        Validator.notNull((Object)((Object)getDocumentOptions), (String)"getDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getDocumentOptions.projectId());
        pathParamsMap.put("collection_id", getDocumentOptions.collectionId());
        pathParamsMap.put("document_id", getDocumentOptions.documentId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/documents/{document_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentDetails>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentAccepted> updateDocument(UpdateDocumentOptions updateDocumentOptions) {
        Validator.notNull((Object)((Object)updateDocumentOptions), (String)"updateDocumentOptions cannot be null");
        Validator.isTrue((updateDocumentOptions.file() != null || updateDocumentOptions.metadata() != null ? 1 : 0) != 0, (String)"At least one of file or metadata must be supplied.");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateDocumentOptions.projectId());
        pathParamsMap.put("collection_id", updateDocumentOptions.collectionId());
        pathParamsMap.put("document_id", updateDocumentOptions.documentId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/documents/{document_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (updateDocumentOptions.xWatsonDiscoveryForce() != null) {
            builder.header(new Object[]{"X-Watson-Discovery-Force", updateDocumentOptions.xWatsonDiscoveryForce()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (updateDocumentOptions.file() != null) {
            RequestBody fileBody = RequestUtils.inputStreamBody((InputStream)updateDocumentOptions.file(), (String)updateDocumentOptions.fileContentType());
            multipartBuilder.addFormDataPart("file", updateDocumentOptions.filename(), fileBody);
        }
        if (updateDocumentOptions.metadata() != null) {
            multipartBuilder.addFormDataPart("metadata", updateDocumentOptions.metadata());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentAccepted>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DeleteDocumentResponse> deleteDocument(DeleteDocumentOptions deleteDocumentOptions) {
        Validator.notNull((Object)((Object)deleteDocumentOptions), (String)"deleteDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteDocumentOptions.projectId());
        pathParamsMap.put("collection_id", deleteDocumentOptions.collectionId());
        pathParamsMap.put("document_id", deleteDocumentOptions.documentId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/documents/{document_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (deleteDocumentOptions.xWatsonDiscoveryForce() != null) {
            builder.header(new Object[]{"X-Watson-Discovery-Force", deleteDocumentOptions.xWatsonDiscoveryForce()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteDocumentResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<QueryResponse> query(QueryOptions queryOptions) {
        Validator.notNull((Object)((Object)queryOptions), (String)"queryOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", queryOptions.projectId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/query", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"query");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (queryOptions.collectionIds() != null) {
            contentJson.add("collection_ids", GsonSingleton.getGson().toJsonTree(queryOptions.collectionIds()));
        }
        if (queryOptions.filter() != null) {
            contentJson.addProperty("filter", queryOptions.filter());
        }
        if (queryOptions.query() != null) {
            contentJson.addProperty("query", queryOptions.query());
        }
        if (queryOptions.naturalLanguageQuery() != null) {
            contentJson.addProperty("natural_language_query", queryOptions.naturalLanguageQuery());
        }
        if (queryOptions.aggregation() != null) {
            contentJson.addProperty("aggregation", queryOptions.aggregation());
        }
        if (queryOptions.count() != null) {
            contentJson.addProperty("count", (Number)queryOptions.count());
        }
        if (queryOptions.xReturn() != null) {
            contentJson.add("return", GsonSingleton.getGson().toJsonTree(queryOptions.xReturn()));
        }
        if (queryOptions.offset() != null) {
            contentJson.addProperty("offset", (Number)queryOptions.offset());
        }
        if (queryOptions.sort() != null) {
            contentJson.addProperty("sort", queryOptions.sort());
        }
        if (queryOptions.highlight() != null) {
            contentJson.addProperty("highlight", queryOptions.highlight());
        }
        if (queryOptions.spellingSuggestions() != null) {
            contentJson.addProperty("spelling_suggestions", queryOptions.spellingSuggestions());
        }
        if (queryOptions.tableResults() != null) {
            contentJson.add("table_results", GsonSingleton.getGson().toJsonTree((Object)queryOptions.tableResults()));
        }
        if (queryOptions.suggestedRefinements() != null) {
            contentJson.add("suggested_refinements", GsonSingleton.getGson().toJsonTree((Object)queryOptions.suggestedRefinements()));
        }
        if (queryOptions.passages() != null) {
            contentJson.add("passages", GsonSingleton.getGson().toJsonTree((Object)queryOptions.passages()));
        }
        if (queryOptions.similar() != null) {
            contentJson.add("similar", GsonSingleton.getGson().toJsonTree((Object)queryOptions.similar()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<QueryResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Completions> getAutocompletion(GetAutocompletionOptions getAutocompletionOptions) {
        Validator.notNull((Object)((Object)getAutocompletionOptions), (String)"getAutocompletionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getAutocompletionOptions.projectId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/autocompletion", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getAutocompletion");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        builder.query(new Object[]{"prefix", String.valueOf(getAutocompletionOptions.prefix())});
        if (getAutocompletionOptions.collectionIds() != null) {
            builder.query(new Object[]{"collection_ids", RequestUtils.join(getAutocompletionOptions.collectionIds(), (String)",")});
        }
        if (getAutocompletionOptions.field() != null) {
            builder.query(new Object[]{"field", String.valueOf(getAutocompletionOptions.field())});
        }
        if (getAutocompletionOptions.count() != null) {
            builder.query(new Object[]{"count", String.valueOf(getAutocompletionOptions.count())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Completions>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<QueryNoticesResponse> queryCollectionNotices(QueryCollectionNoticesOptions queryCollectionNoticesOptions) {
        Validator.notNull((Object)((Object)queryCollectionNoticesOptions), (String)"queryCollectionNoticesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", queryCollectionNoticesOptions.projectId());
        pathParamsMap.put("collection_id", queryCollectionNoticesOptions.collectionId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/notices", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"queryCollectionNotices");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (queryCollectionNoticesOptions.filter() != null) {
            builder.query(new Object[]{"filter", String.valueOf(queryCollectionNoticesOptions.filter())});
        }
        if (queryCollectionNoticesOptions.query() != null) {
            builder.query(new Object[]{"query", String.valueOf(queryCollectionNoticesOptions.query())});
        }
        if (queryCollectionNoticesOptions.naturalLanguageQuery() != null) {
            builder.query(new Object[]{"natural_language_query", String.valueOf(queryCollectionNoticesOptions.naturalLanguageQuery())});
        }
        if (queryCollectionNoticesOptions.count() != null) {
            builder.query(new Object[]{"count", String.valueOf(queryCollectionNoticesOptions.count())});
        }
        if (queryCollectionNoticesOptions.offset() != null) {
            builder.query(new Object[]{"offset", String.valueOf(queryCollectionNoticesOptions.offset())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<QueryNoticesResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<QueryNoticesResponse> queryNotices(QueryNoticesOptions queryNoticesOptions) {
        Validator.notNull((Object)((Object)queryNoticesOptions), (String)"queryNoticesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", queryNoticesOptions.projectId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/notices", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"queryNotices");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (queryNoticesOptions.filter() != null) {
            builder.query(new Object[]{"filter", String.valueOf(queryNoticesOptions.filter())});
        }
        if (queryNoticesOptions.query() != null) {
            builder.query(new Object[]{"query", String.valueOf(queryNoticesOptions.query())});
        }
        if (queryNoticesOptions.naturalLanguageQuery() != null) {
            builder.query(new Object[]{"natural_language_query", String.valueOf(queryNoticesOptions.naturalLanguageQuery())});
        }
        if (queryNoticesOptions.count() != null) {
            builder.query(new Object[]{"count", String.valueOf(queryNoticesOptions.count())});
        }
        if (queryNoticesOptions.offset() != null) {
            builder.query(new Object[]{"offset", String.valueOf(queryNoticesOptions.offset())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<QueryNoticesResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<StopWordList> getStopwordList(GetStopwordListOptions getStopwordListOptions) {
        Validator.notNull((Object)((Object)getStopwordListOptions), (String)"getStopwordListOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getStopwordListOptions.projectId());
        pathParamsMap.put("collection_id", getStopwordListOptions.collectionId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/stopwords", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getStopwordList");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<StopWordList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<StopWordList> createStopwordList(CreateStopwordListOptions createStopwordListOptions) {
        Validator.notNull((Object)((Object)createStopwordListOptions), (String)"createStopwordListOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createStopwordListOptions.projectId());
        pathParamsMap.put("collection_id", createStopwordListOptions.collectionId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/stopwords", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createStopwordList");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (createStopwordListOptions.stopwords() != null) {
            contentJson.add("stopwords", GsonSingleton.getGson().toJsonTree(createStopwordListOptions.stopwords()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<StopWordList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteStopwordList(DeleteStopwordListOptions deleteStopwordListOptions) {
        Validator.notNull((Object)((Object)deleteStopwordListOptions), (String)"deleteStopwordListOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteStopwordListOptions.projectId());
        pathParamsMap.put("collection_id", deleteStopwordListOptions.collectionId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/stopwords", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteStopwordList");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Expansions> listExpansions(ListExpansionsOptions listExpansionsOptions) {
        Validator.notNull((Object)((Object)listExpansionsOptions), (String)"listExpansionsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listExpansionsOptions.projectId());
        pathParamsMap.put("collection_id", listExpansionsOptions.collectionId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/expansions", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listExpansions");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Expansions>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Expansions> createExpansions(CreateExpansionsOptions createExpansionsOptions) {
        Validator.notNull((Object)((Object)createExpansionsOptions), (String)"createExpansionsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createExpansionsOptions.projectId());
        pathParamsMap.put("collection_id", createExpansionsOptions.collectionId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/expansions", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createExpansions");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.add("expansions", GsonSingleton.getGson().toJsonTree(createExpansionsOptions.expansions()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Expansions>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteExpansions(DeleteExpansionsOptions deleteExpansionsOptions) {
        Validator.notNull((Object)((Object)deleteExpansionsOptions), (String)"deleteExpansionsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteExpansionsOptions.projectId());
        pathParamsMap.put("collection_id", deleteExpansionsOptions.collectionId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/expansions", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteExpansions");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ComponentSettingsResponse> getComponentSettings(GetComponentSettingsOptions getComponentSettingsOptions) {
        Validator.notNull((Object)((Object)getComponentSettingsOptions), (String)"getComponentSettingsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getComponentSettingsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/component_settings", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getComponentSettings");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ComponentSettingsResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingQuerySet> listTrainingQueries(ListTrainingQueriesOptions listTrainingQueriesOptions) {
        Validator.notNull((Object)((Object)listTrainingQueriesOptions), (String)"listTrainingQueriesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listTrainingQueriesOptions.projectId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/training_data/queries", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listTrainingQueries");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingQuerySet>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteTrainingQueries(DeleteTrainingQueriesOptions deleteTrainingQueriesOptions) {
        Validator.notNull((Object)((Object)deleteTrainingQueriesOptions), (String)"deleteTrainingQueriesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteTrainingQueriesOptions.projectId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/training_data/queries", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteTrainingQueries");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingQuery> createTrainingQuery(CreateTrainingQueryOptions createTrainingQueryOptions) {
        Validator.notNull((Object)((Object)createTrainingQueryOptions), (String)"createTrainingQueryOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createTrainingQueryOptions.projectId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/training_data/queries", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createTrainingQuery");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("natural_language_query", createTrainingQueryOptions.naturalLanguageQuery());
        contentJson.add("examples", GsonSingleton.getGson().toJsonTree(createTrainingQueryOptions.examples()));
        if (createTrainingQueryOptions.filter() != null) {
            contentJson.addProperty("filter", createTrainingQueryOptions.filter());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingQuery>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingQuery> getTrainingQuery(GetTrainingQueryOptions getTrainingQueryOptions) {
        Validator.notNull((Object)((Object)getTrainingQueryOptions), (String)"getTrainingQueryOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getTrainingQueryOptions.projectId());
        pathParamsMap.put("query_id", getTrainingQueryOptions.queryId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/training_data/queries/{query_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getTrainingQuery");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingQuery>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingQuery> updateTrainingQuery(UpdateTrainingQueryOptions updateTrainingQueryOptions) {
        Validator.notNull((Object)((Object)updateTrainingQueryOptions), (String)"updateTrainingQueryOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateTrainingQueryOptions.projectId());
        pathParamsMap.put("query_id", updateTrainingQueryOptions.queryId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/training_data/queries/{query_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateTrainingQuery");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("natural_language_query", updateTrainingQueryOptions.naturalLanguageQuery());
        contentJson.add("examples", GsonSingleton.getGson().toJsonTree(updateTrainingQueryOptions.examples()));
        if (updateTrainingQueryOptions.filter() != null) {
            contentJson.addProperty("filter", updateTrainingQueryOptions.filter());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingQuery>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteTrainingQuery(DeleteTrainingQueryOptions deleteTrainingQueryOptions) {
        Validator.notNull((Object)((Object)deleteTrainingQueryOptions), (String)"deleteTrainingQueryOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteTrainingQueryOptions.projectId());
        pathParamsMap.put("query_id", deleteTrainingQueryOptions.queryId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/training_data/queries/{query_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteTrainingQuery");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Enrichments> listEnrichments(ListEnrichmentsOptions listEnrichmentsOptions) {
        Validator.notNull((Object)((Object)listEnrichmentsOptions), (String)"listEnrichmentsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listEnrichmentsOptions.projectId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/enrichments", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listEnrichments");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Enrichments>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Enrichment> createEnrichment(CreateEnrichmentOptions createEnrichmentOptions) {
        Validator.notNull((Object)((Object)createEnrichmentOptions), (String)"createEnrichmentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createEnrichmentOptions.projectId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/enrichments", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createEnrichment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("enrichment", createEnrichmentOptions.enrichment().toString());
        if (createEnrichmentOptions.file() != null) {
            RequestBody fileBody = RequestUtils.inputStreamBody((InputStream)createEnrichmentOptions.file(), (String)"application/octet-stream");
            multipartBuilder.addFormDataPart("file", "filename", fileBody);
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Enrichment>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Enrichment> getEnrichment(GetEnrichmentOptions getEnrichmentOptions) {
        Validator.notNull((Object)((Object)getEnrichmentOptions), (String)"getEnrichmentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getEnrichmentOptions.projectId());
        pathParamsMap.put("enrichment_id", getEnrichmentOptions.enrichmentId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/enrichments/{enrichment_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getEnrichment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Enrichment>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Enrichment> updateEnrichment(UpdateEnrichmentOptions updateEnrichmentOptions) {
        Validator.notNull((Object)((Object)updateEnrichmentOptions), (String)"updateEnrichmentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateEnrichmentOptions.projectId());
        pathParamsMap.put("enrichment_id", updateEnrichmentOptions.enrichmentId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/enrichments/{enrichment_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateEnrichment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", updateEnrichmentOptions.name());
        if (updateEnrichmentOptions.description() != null) {
            contentJson.addProperty("description", updateEnrichmentOptions.description());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Enrichment>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteEnrichment(DeleteEnrichmentOptions deleteEnrichmentOptions) {
        Validator.notNull((Object)((Object)deleteEnrichmentOptions), (String)"deleteEnrichmentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteEnrichmentOptions.projectId());
        pathParamsMap.put("enrichment_id", deleteEnrichmentOptions.enrichmentId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/enrichments/{enrichment_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteEnrichment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentClassifiers> listDocumentClassifiers(ListDocumentClassifiersOptions listDocumentClassifiersOptions) {
        Validator.notNull((Object)((Object)listDocumentClassifiersOptions), (String)"listDocumentClassifiersOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listDocumentClassifiersOptions.projectId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/document_classifiers", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listDocumentClassifiers");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentClassifiers>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentClassifier> createDocumentClassifier(CreateDocumentClassifierOptions createDocumentClassifierOptions) {
        Validator.notNull((Object)((Object)createDocumentClassifierOptions), (String)"createDocumentClassifierOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createDocumentClassifierOptions.projectId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/document_classifiers", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createDocumentClassifier");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        RequestBody trainingDataBody = RequestUtils.inputStreamBody((InputStream)createDocumentClassifierOptions.trainingData(), (String)"text/csv");
        multipartBuilder.addFormDataPart("training_data", "filename", trainingDataBody);
        multipartBuilder.addFormDataPart("classifier", createDocumentClassifierOptions.classifier().toString());
        if (createDocumentClassifierOptions.testData() != null) {
            RequestBody testDataBody = RequestUtils.inputStreamBody((InputStream)createDocumentClassifierOptions.testData(), (String)"text/csv");
            multipartBuilder.addFormDataPart("test_data", "filename", testDataBody);
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentClassifier>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentClassifier> getDocumentClassifier(GetDocumentClassifierOptions getDocumentClassifierOptions) {
        Validator.notNull((Object)((Object)getDocumentClassifierOptions), (String)"getDocumentClassifierOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getDocumentClassifierOptions.projectId());
        pathParamsMap.put("classifier_id", getDocumentClassifierOptions.classifierId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/document_classifiers/{classifier_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getDocumentClassifier");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentClassifier>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentClassifier> updateDocumentClassifier(UpdateDocumentClassifierOptions updateDocumentClassifierOptions) {
        Validator.notNull((Object)((Object)updateDocumentClassifierOptions), (String)"updateDocumentClassifierOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateDocumentClassifierOptions.projectId());
        pathParamsMap.put("classifier_id", updateDocumentClassifierOptions.classifierId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/document_classifiers/{classifier_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateDocumentClassifier");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("classifier", updateDocumentClassifierOptions.classifier().toString());
        if (updateDocumentClassifierOptions.trainingData() != null) {
            RequestBody trainingDataBody = RequestUtils.inputStreamBody((InputStream)updateDocumentClassifierOptions.trainingData(), (String)"text/csv");
            multipartBuilder.addFormDataPart("training_data", "filename", trainingDataBody);
        }
        if (updateDocumentClassifierOptions.testData() != null) {
            RequestBody testDataBody = RequestUtils.inputStreamBody((InputStream)updateDocumentClassifierOptions.testData(), (String)"text/csv");
            multipartBuilder.addFormDataPart("test_data", "filename", testDataBody);
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentClassifier>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteDocumentClassifier(DeleteDocumentClassifierOptions deleteDocumentClassifierOptions) {
        Validator.notNull((Object)((Object)deleteDocumentClassifierOptions), (String)"deleteDocumentClassifierOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteDocumentClassifierOptions.projectId());
        pathParamsMap.put("classifier_id", deleteDocumentClassifierOptions.classifierId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/document_classifiers/{classifier_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteDocumentClassifier");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentClassifierModels> listDocumentClassifierModels(ListDocumentClassifierModelsOptions listDocumentClassifierModelsOptions) {
        Validator.notNull((Object)((Object)listDocumentClassifierModelsOptions), (String)"listDocumentClassifierModelsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", listDocumentClassifierModelsOptions.projectId());
        pathParamsMap.put("classifier_id", listDocumentClassifierModelsOptions.classifierId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/document_classifiers/{classifier_id}/models", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"listDocumentClassifierModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentClassifierModels>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentClassifierModel> createDocumentClassifierModel(CreateDocumentClassifierModelOptions createDocumentClassifierModelOptions) {
        Validator.notNull((Object)((Object)createDocumentClassifierModelOptions), (String)"createDocumentClassifierModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", createDocumentClassifierModelOptions.projectId());
        pathParamsMap.put("classifier_id", createDocumentClassifierModelOptions.classifierId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/document_classifiers/{classifier_id}/models", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"createDocumentClassifierModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createDocumentClassifierModelOptions.name());
        if (createDocumentClassifierModelOptions.description() != null) {
            contentJson.addProperty("description", createDocumentClassifierModelOptions.description());
        }
        if (createDocumentClassifierModelOptions.learningRate() != null) {
            contentJson.addProperty("learning_rate", (Number)createDocumentClassifierModelOptions.learningRate());
        }
        if (createDocumentClassifierModelOptions.l1RegularizationStrengths() != null) {
            contentJson.add("l1_regularization_strengths", GsonSingleton.getGson().toJsonTree(createDocumentClassifierModelOptions.l1RegularizationStrengths()));
        }
        if (createDocumentClassifierModelOptions.l2RegularizationStrengths() != null) {
            contentJson.add("l2_regularization_strengths", GsonSingleton.getGson().toJsonTree(createDocumentClassifierModelOptions.l2RegularizationStrengths()));
        }
        if (createDocumentClassifierModelOptions.trainingMaxSteps() != null) {
            contentJson.addProperty("training_max_steps", (Number)createDocumentClassifierModelOptions.trainingMaxSteps());
        }
        if (createDocumentClassifierModelOptions.improvementRatio() != null) {
            contentJson.addProperty("improvement_ratio", (Number)createDocumentClassifierModelOptions.improvementRatio());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentClassifierModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentClassifierModel> getDocumentClassifierModel(GetDocumentClassifierModelOptions getDocumentClassifierModelOptions) {
        Validator.notNull((Object)((Object)getDocumentClassifierModelOptions), (String)"getDocumentClassifierModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", getDocumentClassifierModelOptions.projectId());
        pathParamsMap.put("classifier_id", getDocumentClassifierModelOptions.classifierId());
        pathParamsMap.put("model_id", getDocumentClassifierModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/document_classifiers/{classifier_id}/models/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"getDocumentClassifierModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentClassifierModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentClassifierModel> updateDocumentClassifierModel(UpdateDocumentClassifierModelOptions updateDocumentClassifierModelOptions) {
        Validator.notNull((Object)((Object)updateDocumentClassifierModelOptions), (String)"updateDocumentClassifierModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", updateDocumentClassifierModelOptions.projectId());
        pathParamsMap.put("classifier_id", updateDocumentClassifierModelOptions.classifierId());
        pathParamsMap.put("model_id", updateDocumentClassifierModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/document_classifiers/{classifier_id}/models/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"updateDocumentClassifierModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (updateDocumentClassifierModelOptions.name() != null) {
            contentJson.addProperty("name", updateDocumentClassifierModelOptions.name());
        }
        if (updateDocumentClassifierModelOptions.description() != null) {
            contentJson.addProperty("description", updateDocumentClassifierModelOptions.description());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentClassifierModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteDocumentClassifierModel(DeleteDocumentClassifierModelOptions deleteDocumentClassifierModelOptions) {
        Validator.notNull((Object)((Object)deleteDocumentClassifierModelOptions), (String)"deleteDocumentClassifierModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", deleteDocumentClassifierModelOptions.projectId());
        pathParamsMap.put("classifier_id", deleteDocumentClassifierModelOptions.classifierId());
        pathParamsMap.put("model_id", deleteDocumentClassifierModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/document_classifiers/{classifier_id}/models/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteDocumentClassifierModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AnalyzedDocument> analyzeDocument(AnalyzeDocumentOptions analyzeDocumentOptions) {
        Validator.notNull((Object)((Object)analyzeDocumentOptions), (String)"analyzeDocumentOptions cannot be null");
        Validator.isTrue((analyzeDocumentOptions.file() != null || analyzeDocumentOptions.metadata() != null ? 1 : 0) != 0, (String)"At least one of file or metadata must be supplied.");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("project_id", analyzeDocumentOptions.projectId());
        pathParamsMap.put("collection_id", analyzeDocumentOptions.collectionId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/projects/{project_id}/collections/{collection_id}/analyze", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"analyzeDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (analyzeDocumentOptions.file() != null) {
            RequestBody fileBody = RequestUtils.inputStreamBody((InputStream)analyzeDocumentOptions.file(), (String)analyzeDocumentOptions.fileContentType());
            multipartBuilder.addFormDataPart("file", analyzeDocumentOptions.filename(), fileBody);
        }
        if (analyzeDocumentOptions.metadata() != null) {
            multipartBuilder.addFormDataPart("metadata", analyzeDocumentOptions.metadata());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AnalyzedDocument>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull((Object)((Object)deleteUserDataOptions), (String)"deleteUserDataOptions cannot be null");
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/user_data"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v2", (String)"deleteUserData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        builder.query(new Object[]{"customer_id", String.valueOf(deleteUserDataOptions.customerId())});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

