/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class Expansion
extends GenericModel {
    @SerializedName(value="input_terms")
    protected List<String> inputTerms;
    @SerializedName(value="expanded_terms")
    protected List<String> expandedTerms;

    protected Expansion() {
    }

    protected Expansion(Builder builder) {
        Validator.notNull((Object)builder.expandedTerms, (String)"expandedTerms cannot be null");
        this.inputTerms = builder.inputTerms;
        this.expandedTerms = builder.expandedTerms;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<String> inputTerms() {
        return this.inputTerms;
    }

    public List<String> expandedTerms() {
        return this.expandedTerms;
    }

    public static class Builder {
        private List<String> inputTerms;
        private List<String> expandedTerms;

        private Builder(Expansion expansion) {
            this.inputTerms = expansion.inputTerms;
            this.expandedTerms = expansion.expandedTerms;
        }

        public Builder() {
        }

        public Builder(List<String> expandedTerms) {
            this.expandedTerms = expandedTerms;
        }

        public Expansion build() {
            return new Expansion(this);
        }

        public Builder addInputTerms(String inputTerms) {
            Validator.notNull((Object)inputTerms, (String)"inputTerms cannot be null");
            if (this.inputTerms == null) {
                this.inputTerms = new ArrayList<String>();
            }
            this.inputTerms.add(inputTerms);
            return this;
        }

        public Builder addExpandedTerms(String expandedTerms) {
            Validator.notNull((Object)expandedTerms, (String)"expandedTerms cannot be null");
            if (this.expandedTerms == null) {
                this.expandedTerms = new ArrayList<String>();
            }
            this.expandedTerms.add(expandedTerms);
            return this;
        }

        public Builder inputTerms(List<String> inputTerms) {
            this.inputTerms = inputTerms;
            return this;
        }

        public Builder expandedTerms(List<String> expandedTerms) {
            this.expandedTerms = expandedTerms;
            return this;
        }
    }
}

