/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.watson.developer_cloud.util.DateDeserializer;
import com.ibm.watson.developer_cloud.util.DateSerializer;
import java.util.Date;

public class GsonSingleton {
    private static Gson gson;
    private static Gson gsonWithoutPrinting;

    private static Gson createGson(Boolean prettyPrint) {
        GsonBuilder builder = new GsonBuilder();
        GsonSingleton.registerTypeAdapters(builder);
        if (prettyPrint.booleanValue()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    private static void registerTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter(Date.class, (Object)new DateDeserializer());
        builder.registerTypeAdapter(Date.class, (Object)new DateSerializer());
    }

    public static Gson getGsonWithoutPrettyPrinting() {
        if (gsonWithoutPrinting == null) {
            gsonWithoutPrinting = GsonSingleton.createGson(false);
        }
        return gsonWithoutPrinting;
    }

    public static Gson getGson() {
        if (gson == null) {
            gson = GsonSingleton.createGson(true);
        }
        return gson;
    }
}

