/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tradeoff_analytics.v1;

import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.Dilemma;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.Problem;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import org.apache.commons.lang3.Validate;

public class TradeoffAnalytics
extends WatsonService {
    private static final String GENERATE_VISUALIZATION = "generate_visualization";
    private static final String PATH_DILEMMAS = "/v1/dilemmas";
    private static final String URL = "https://gateway.watsonplatform.net/tradeoff-analytics/api";

    public TradeoffAnalytics() {
        super("tradeoff_analytics");
        this.setEndPoint(URL);
    }

    public Dilemma dilemmas(Problem problem) {
        return this.dilemmas(problem, null);
    }

    public Dilemma dilemmas(Problem problem, Boolean generateVisualization) {
        Validate.notNull((Object)problem, (String)"problem was not specified", (Object[])new Object[0]);
        String contentJson = GsonSingleton.getGsonWithoutPrettyPrinting().toJson((Object)problem);
        RequestBuilder requestBuilder = RequestBuilder.post(PATH_DILEMMAS).withBodyContent(contentJson, "application/json");
        if (generateVisualization != null) {
            requestBuilder.withQuery(GENERATE_VISUALIZATION, generateVisualization);
        }
        return this.executeRequest(requestBuilder.build(), Dilemma.class);
    }
}

