/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.http;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.NameValue;
import com.ibm.watson.developer_cloud.util.RequestUtil;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RequestBuilder {
    private RequestBody body;
    private final List<NameValue> formParams = new ArrayList<NameValue>();
    private final List<NameValue> headers = new ArrayList<NameValue>();
    private HttpUrl httpUrl;
    private final HTTPMethod method;
    private final List<NameValue> queryParams = new ArrayList<NameValue>();

    public static RequestBuilder delete(String url) {
        return new RequestBuilder(HTTPMethod.DELETE, url);
    }

    public static RequestBuilder get(String url) {
        return new RequestBuilder(HTTPMethod.GET, url);
    }

    public static RequestBuilder post(String url) {
        return new RequestBuilder(HTTPMethod.POST, url);
    }

    public static RequestBuilder put(String url) {
        return new RequestBuilder(HTTPMethod.PUT, url);
    }

    private RequestBuilder(HTTPMethod method, String url) {
        this.method = method;
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        this.httpUrl = HttpUrl.parse((String)url);
        if (this.httpUrl == null) {
            this.httpUrl = HttpUrl.parse((String)("http://do.not.use" + url));
        }
    }

    private RequestBuilder add(List<NameValue> params, String name, Object value) {
        if (value instanceof Iterable) {
            for (Object o : (Iterable)value) {
                this.addParam(params, name, o);
            }
        } else if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                this.addParam(params, name, o);
            }
        } else {
            this.addParam(params, name, value);
        }
        return this;
    }

    private void addParam(List<NameValue> params, String name, Object value) {
        params.add(new NameValue(name, value == null ? null : String.valueOf(value)));
    }

    public Request build() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.toUrl());
        RequestBody requestBody = this.body;
        if (this.body == null) {
            requestBody = RequestBody.create(null, (byte[])new byte[0]);
        }
        if (!this.formParams.isEmpty()) {
            FormEncodingBuilder formBody = new FormEncodingBuilder();
            for (NameValue param : this.formParams) {
                String value = param.getValue() != null ? param.getValue() : "";
                formBody.add(param.getName(), value);
            }
            requestBody = formBody.build();
        }
        builder.addHeader("Accept", "application/json");
        if (!this.headers.isEmpty()) {
            for (NameValue header : this.headers) {
                builder.addHeader(header.getName(), header.getValue());
            }
        }
        switch (this.method) {
            case GET: {
                builder.get();
                break;
            }
            case POST: {
                builder.post(requestBody);
                break;
            }
            case PUT: {
                builder.put(requestBody);
                break;
            }
            case DELETE: {
                builder.delete(requestBody);
            }
        }
        return builder.build();
    }

    public String toString() {
        return "RequestBuilder [method=" + (Object)((Object)this.method) + ", formParams=" + this.formParams + ", headers=" + this.headers + ", queryParams=" + this.queryParams + ", httpUrl=" + this.httpUrl + "]";
    }

    public String toUrl() {
        HttpUrl.Builder builder = this.httpUrl.newBuilder();
        for (NameValue param : this.queryParams) {
            builder.addEncodedQueryParameter(RequestUtil.encode(param.getName()), RequestUtil.encode(param.getValue()));
        }
        return builder.build().url().toString();
    }

    private RequestBuilder with(List<NameValue> params, Object ... args) {
        if (args != null) {
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("need even number of arguments");
            }
            for (int i = 0; i < args.length; i += 2) {
                this.add(params, args[i].toString(), args[i + 1]);
            }
        }
        return this;
    }

    public RequestBuilder withBody(RequestBody body) {
        this.body = body;
        return this;
    }

    public RequestBuilder withBodyContent(String content, String contentType) {
        this.body = RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)content);
        return this;
    }

    public RequestBuilder withBodyJson(JsonObject json) {
        return this.withBodyContent(json.toString(), "application/json");
    }

    public RequestBuilder withForm(Object ... args) {
        return this.with(this.formParams, args);
    }

    public RequestBuilder withFormMap(Map<String, Object> parameters) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            this.withForm(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public RequestBuilder withHeader(Object ... args) {
        return this.with(this.headers, args);
    }

    public RequestBuilder withQuery(Object ... args) {
        return this.with(this.queryParams, args);
    }

    public RequestBuilder withQueryMap(Map<String, Object> parameters) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            this.withQuery(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private static enum HTTPMethod {
        DELETE,
        GET,
        POST,
        PUT;

    }
}

