/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.android.library.audio;

import android.media.AudioRecord;
import android.os.Process;
import com.ibm.watson.developer_cloud.android.library.audio.AudioConsumer;
import com.ibm.watson.developer_cloud.android.library.audio.opus.OggOpusEnc;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.locks.ReentrantLock;

final class MicrophoneCaptureThread
implements Runnable {
    private static final String TAG = MicrophoneCaptureThread.class.getName();
    private static final int SAMPLE_RATE = 16000;
    private final AudioConsumer consumer;
    private boolean opusEncoded;
    private OggOpusEnc encoder;
    private AudioRecord record;
    private ReentrantLock running = new ReentrantLock();
    private PipedOutputStream os;
    private PipedInputStream is;
    private boolean doStop = false;

    public synchronized void doStop() {
        this.doStop = true;
    }

    private synchronized boolean keepRunning() {
        return !this.doStop;
    }

    public MicrophoneCaptureThread(AudioConsumer consumer, boolean opusEncoded) {
        Process.setThreadPriority((int)-19);
        this.consumer = consumer;
        this.opusEncoded = opusEncoded;
    }

    @Override
    public void run() {
        int bufferSize = Math.max(8000, AudioRecord.getMinBufferSize((int)16000, (int)16, (int)2));
        short[] buffer = new short[bufferSize];
        this.record = new AudioRecord(1, 16000, 16, 2, bufferSize);
        this.record.startRecording();
        if (this.opusEncoded) {
            try {
                this.encoder = new OggOpusEnc(this.consumer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (this.keepRunning()) {
            try {
                int r = this.record.read(buffer, 0, buffer.length);
                long v = 0L;
                for (int i = 0; i < r; ++i) {
                    v += (long)(buffer[i] * buffer[i]);
                }
                double amplitude = (double)v / (double)r;
                double volume = 0.0;
                if (amplitude > 0.0) {
                    volume = 10.0 * Math.log10(amplitude);
                }
                ByteBuffer bufferBytes = ByteBuffer.allocate(r * 2);
                bufferBytes.order(ByteOrder.LITTLE_ENDIAN);
                bufferBytes.asShortBuffer().put(buffer, 0, r);
                byte[] bytes = bufferBytes.array();
                if (this.opusEncoded) {
                    this.encoder.onStart();
                    this.encoder.encodeAndWrite(bytes);
                    continue;
                }
                this.consumer.consume(bytes, amplitude, volume);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.encoder != null) {
            this.encoder.close();
        }
        this.record.stop();
        this.record.release();
    }
}

