/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.android.library.audio;

import android.util.Log;
import com.ibm.watson.developer_cloud.android.library.audio.AmplitudeListener;
import com.ibm.watson.developer_cloud.android.library.audio.AudioConsumer;
import com.ibm.watson.developer_cloud.android.library.audio.MicrophoneCaptureThread;
import com.ibm.watson.developer_cloud.android.library.audio.utils.ContentType;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public final class MicrophoneInputStream
extends InputStream
implements AudioConsumer {
    private static final String TAG = MicrophoneInputStream.class.getName();
    public final ContentType CONTENT_TYPE;
    private final MicrophoneCaptureThread captureThread;
    private final PipedOutputStream os;
    private final PipedInputStream is;
    private AmplitudeListener amplitudeListener;

    public MicrophoneInputStream(boolean opusEncoded) {
        this.captureThread = new MicrophoneCaptureThread(this, opusEncoded);
        this.CONTENT_TYPE = opusEncoded ? ContentType.OPUS : ContentType.RAW;
        this.os = new PipedOutputStream();
        this.is = new PipedInputStream();
        try {
            this.is.connect(this.os);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        this.captureThread.start();
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("Call read(byte[]) or read(byte[], int, int)");
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.is.read(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.os.close();
        this.is.close();
        this.captureThread.end();
    }

    @Override
    public void consume(byte[] data, double amplitude, double volume) {
        if (this.amplitudeListener != null) {
            this.amplitudeListener.onSample(amplitude, volume);
        }
        try {
            this.os.write(data);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    @Override
    public void consume(byte[] data) {
        try {
            this.os.write(data);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void setOnAmplitudeListener(AmplitudeListener listener) {
        this.amplitudeListener = listener;
    }

    public String getContentType() {
        return this.CONTENT_TYPE.toString();
    }
}

