/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.android.library.audio;

import android.media.AudioTrack;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class StreamPlayer {
    private final String TAG = "StreamPlayer";
    private final int DEFAULT_SAMPLE_RATE = 22050;
    private AudioTrack audioTrack;

    private static byte[] convertStreamToByteArray(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[10240];
        while ((i = is.read(buff, 0, buff.length)) > 0) {
            baos.write(buff, 0, i);
        }
        return baos.toByteArray();
    }

    public void playStream(InputStream stream) {
        try {
            byte[] data = StreamPlayer.convertStreamToByteArray(stream);
            int headSize = 44;
            int metaDataSize = 48;
            int destPos = headSize + metaDataSize;
            int rawLength = data.length - destPos;
            byte[] d = new byte[rawLength];
            System.arraycopy(data, destPos, d, 0, rawLength);
            this.initPlayer(22050);
            this.audioTrack.write(d, 0, d.length);
            stream.close();
            if (this.audioTrack != null && this.audioTrack.getState() != 0) {
                this.audioTrack.release();
            }
        }
        catch (IOException e2) {
            Log.e((String)"StreamPlayer", (String)e2.getMessage());
        }
    }

    public void playStream(InputStream stream, int sampleRate) {
        try {
            byte[] data = StreamPlayer.convertStreamToByteArray(stream);
            int headSize = 44;
            int metaDataSize = 48;
            int destPos = headSize + metaDataSize;
            int rawLength = data.length - destPos;
            byte[] d = new byte[rawLength];
            System.arraycopy(data, destPos, d, 0, rawLength);
            this.initPlayer(sampleRate);
            this.audioTrack.write(d, 0, d.length);
            stream.close();
            if (this.audioTrack != null && this.audioTrack.getState() != 0) {
                this.audioTrack.release();
            }
        }
        catch (IOException e2) {
            Log.e((String)"StreamPlayer", (String)e2.getMessage());
        }
    }

    public void interrupt() {
        if (this.audioTrack != null) {
            if (this.audioTrack.getState() == 1 || this.audioTrack.getState() == 3) {
                this.audioTrack.pause();
            }
            this.audioTrack.flush();
            this.audioTrack.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPlayer(int sampleRate) {
        StreamPlayer streamPlayer = this;
        synchronized (streamPlayer) {
            int bufferSize = AudioTrack.getMinBufferSize((int)sampleRate, (int)4, (int)2);
            if (bufferSize == -2) {
                throw new RuntimeException("Could not determine buffer size for audio");
            }
            this.audioTrack = new AudioTrack(3, sampleRate, 4, 2, bufferSize, 1);
            this.audioTrack.play();
        }
    }
}

