/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.android.library.audio;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AudioFileWriter {
    public static int writeOggPageHeader(byte[] buf, int offset, int headerType, long granulepos, int streamSerialNumber, int pageCount, int packetCount, byte[] packetSizes) {
        AudioFileWriter.writeString(buf, offset, "OggS");
        buf[offset + 4] = 0;
        buf[offset + 5] = (byte)headerType;
        AudioFileWriter.writeLong(buf, offset + 6, granulepos);
        AudioFileWriter.writeInt(buf, offset + 14, streamSerialNumber);
        AudioFileWriter.writeInt(buf, offset + 18, pageCount);
        AudioFileWriter.writeInt(buf, offset + 22, 0);
        buf[offset + 26] = (byte)packetCount;
        System.arraycopy(packetSizes, 0, buf, offset + 27, packetCount);
        return packetCount + 27;
    }

    public static byte[] buildOggPageHeader(int headerType, long granulepos, int streamSerialNumber, int pageCount, int packetCount, byte[] packetSizes) {
        byte[] data = new byte[packetCount + 27];
        AudioFileWriter.writeOggPageHeader(data, 0, headerType, granulepos, streamSerialNumber, pageCount, packetCount, packetSizes);
        return data;
    }

    public static byte[] buildOpusHeader(int sampleRate) {
        byte[] data = new byte[19];
        AudioFileWriter.writeOpusHeader(data, 0, sampleRate);
        return data;
    }

    public static void writeOpusHeader(byte[] buf, int offset, int sampleRate) {
        AudioFileWriter.writeString(buf, offset, "OpusHead");
        buf[offset + 8] = 1;
        buf[offset + 9] = 1;
        AudioFileWriter.writeShort(buf, offset + 10, 0);
        AudioFileWriter.writeInt(buf, offset + 12, sampleRate);
        AudioFileWriter.writeShort(buf, offset + 16, 0);
        buf[offset + 18] = 0;
    }

    public static void writeOpusComment(byte[] buf, int offset, String comment) {
        AudioFileWriter.writeString(buf, offset, "OpusTags");
        String vendorString = "IBM";
        AudioFileWriter.writeInt(buf, offset + 8, vendorString.length());
        AudioFileWriter.writeString(buf, offset + 12, vendorString);
        AudioFileWriter.writeInt(buf, offset + 20, 1);
        AudioFileWriter.writeInt(buf, offset + 24, comment.length());
        AudioFileWriter.writeString(buf, offset + 28, comment);
    }

    public static byte[] buildOpusComment(String comment) {
        byte[] data = new byte[28 + comment.length()];
        AudioFileWriter.writeOpusComment(data, 0, comment);
        return data;
    }

    public static void writeShort(DataOutput out, short v) throws IOException {
        out.writeByte(0xFF & v);
        out.writeByte(0xFF & v >>> 8);
    }

    public static void writeInt(DataOutput out, int v) throws IOException {
        out.writeByte(0xFF & v);
        out.writeByte(0xFF & v >>> 8);
        out.writeByte(0xFF & v >>> 16);
        out.writeByte(0xFF & v >>> 24);
    }

    public static void writeShort(OutputStream os, short v) throws IOException {
        os.write(0xFF & v);
        os.write(0xFF & v >>> 8);
    }

    public static void writeInt(OutputStream os, int v) throws IOException {
        os.write(0xFF & v);
        os.write(0xFF & v >>> 8);
        os.write(0xFF & v >>> 16);
        os.write(0xFF & v >>> 24);
    }

    public static void writeLong(OutputStream os, long v) throws IOException {
        os.write((int)(0xFFL & v));
        os.write((int)(0xFFL & v >>> 8));
        os.write((int)(0xFFL & v >>> 16));
        os.write((int)(0xFFL & v >>> 24));
        os.write((int)(0xFFL & v >>> 32));
        os.write((int)(0xFFL & v >>> 40));
        os.write((int)(0xFFL & v >>> 48));
        os.write((int)(0xFFL & v >>> 56));
    }

    public static void writeShort(byte[] data, int offset, int v) {
        data[offset] = (byte)(0xFF & v);
        data[offset + 1] = (byte)(0xFF & v >>> 8);
    }

    public static void writeInt(byte[] data, int offset, int v) {
        data[offset] = (byte)(0xFF & v);
        data[offset + 1] = (byte)(0xFF & v >>> 8);
        data[offset + 2] = (byte)(0xFF & v >>> 16);
        data[offset + 3] = (byte)(0xFF & v >>> 24);
    }

    public static void writeLong(byte[] data, int offset, long v) {
        data[offset] = (byte)(0xFFL & v);
        data[offset + 1] = (byte)(0xFFL & v >>> 8);
        data[offset + 2] = (byte)(0xFFL & v >>> 16);
        data[offset + 3] = (byte)(0xFFL & v >>> 24);
        data[offset + 4] = (byte)(0xFFL & v >>> 32);
        data[offset + 5] = (byte)(0xFFL & v >>> 40);
        data[offset + 6] = (byte)(0xFFL & v >>> 48);
        data[offset + 7] = (byte)(0xFFL & v >>> 56);
    }

    public static void writeString(byte[] data, int offset, String v) {
        byte[] str = v.getBytes();
        System.arraycopy(str, 0, data, offset, str.length);
    }

    public abstract void close() throws IOException;

    public abstract void open(File var1) throws IOException;

    public abstract void open(String var1) throws IOException;

    public abstract void writeHeader(String var1) throws IOException;

    public abstract void writePacket(byte[] var1, int var2, int var3) throws IOException;
}

