/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.android.library.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class CameraHelper {
    private final String TAG = CameraHelper.class.getName();
    public static final int REQUEST_IMAGE_CAPTURE = 1000;
    public static final int REQUEST_PERMISSION = 3000;
    private Activity activity;
    private String currentPhotoPath;

    public CameraHelper(Activity activity) {
        this.activity = activity;
    }

    public void dispatchTakePictureIntent() {
        Intent takePictureIntent;
        if (this.checkPermissions() && (takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE")).resolveActivity(this.activity.getPackageManager()) != null) {
            File photoFile = null;
            try {
                photoFile = this.createImageFile();
            }
            catch (IOException ex) {
                Log.e((String)this.TAG, (String)"IOException", (Throwable)ex);
            }
            if (photoFile != null) {
                takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)photoFile));
                this.activity.startActivityForResult(takePictureIntent, 1000);
            }
        }
    }

    private boolean checkPermissions() {
        boolean grantExternal;
        String[] permissions = new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
        boolean grantCamera = ContextCompat.checkSelfPermission((Context)this.activity, (String)permissions[0]) == 0;
        boolean bl = grantExternal = ContextCompat.checkSelfPermission((Context)this.activity, (String)permissions[1]) == 0;
        if (!grantCamera && !grantExternal) {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])permissions, (int)3000);
        } else if (!grantCamera) {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{permissions[0]}, (int)3000);
        } else if (!grantExternal) {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{permissions[1]}, (int)3000);
        }
        return grantCamera && grantExternal;
    }

    private File createImageFile() throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        File image = File.createTempFile(imageFileName, ".jpg", storageDir);
        this.currentPhotoPath = "file:" + image.getAbsolutePath();
        return image;
    }

    public File getFile(int resultCode) {
        if (resultCode == -1) {
            Uri targetUri = Uri.parse((String)this.currentPhotoPath);
            return new File(targetUri.getPath());
        }
        Log.e((String)this.TAG, (String)"Result Code was not OK");
        return null;
    }

    public Bitmap getBitmap(int resultCode) {
        if (resultCode == -1) {
            Uri targetUri = Uri.parse((String)this.currentPhotoPath);
            try {
                return BitmapFactory.decodeStream((InputStream)this.activity.getContentResolver().openInputStream(targetUri));
            }
            catch (FileNotFoundException e) {
                Log.e((String)this.TAG, (String)"File Not Found", (Throwable)e);
                return null;
            }
        }
        Log.e((String)this.TAG, (String)"Result Code was not OK");
        return null;
    }
}

