/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.android.library.audio;

import android.media.AudioRecord;
import android.os.Process;
import android.util.Log;
import com.ibm.watson.developer_cloud.android.library.audio.AudioConsumer;
import com.ibm.watson.developer_cloud.android.library.audio.opus.OggOpusEnc;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class MicrophoneCaptureThread
extends Thread {
    private static final String TAG = MicrophoneCaptureThread.class.getName();
    private static final int SAMPLE_RATE = 16000;
    private boolean opusEncoded;
    private OggOpusEnc encoder;
    private final AudioConsumer consumer;
    private boolean stop;
    private boolean stopped;

    public MicrophoneCaptureThread(AudioConsumer consumer, boolean opusEncoded) {
        Process.setThreadPriority((int)-19);
        this.consumer = consumer;
        this.opusEncoded = opusEncoded;
    }

    @Override
    public void run() {
        int bufferSize = Math.max(8000, AudioRecord.getMinBufferSize((int)16000, (int)16, (int)2));
        short[] buffer = new short[bufferSize];
        AudioRecord record = new AudioRecord(1, 16000, 16, 2, bufferSize);
        record.startRecording();
        try {
            this.encoder = new OggOpusEnc(this.consumer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (!this.stop) {
            int r = record.read(buffer, 0, buffer.length);
            long v = 0L;
            for (int i = 0; i < r; ++i) {
                v += (long)(buffer[i] * buffer[i]);
            }
            double amplitude = (double)v / (double)r;
            double volume = 0.0;
            if (amplitude > 0.0) {
                volume = 10.0 * Math.log10(amplitude);
            }
            ByteBuffer bufferBytes = ByteBuffer.allocate(r * 2);
            bufferBytes.order(ByteOrder.LITTLE_ENDIAN);
            bufferBytes.asShortBuffer().put(buffer, 0, r);
            byte[] bytes = bufferBytes.array();
            if (this.opusEncoded) {
                try {
                    this.encoder.onStart();
                    this.encoder.encodeAndWrite(bytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.consumer.consume(bytes, amplitude, volume);
        }
        this.encoder.close();
        record.stop();
        record.release();
        this.stopped = true;
    }

    public void end() {
        this.stop = true;
        while (!this.stopped) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
        }
    }
}

