/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.android.library.camera;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;

public final class GalleryHelper {
    private final String TAG = GalleryHelper.class.getName();
    public static final int PICK_IMAGE_REQUEST = 1001;
    private Activity activity;

    public GalleryHelper(Activity activity) {
        this.activity = activity;
    }

    public void dispatchGalleryIntent() {
        Intent galleryIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        if (galleryIntent.resolveActivity(this.activity.getPackageManager()) != null) {
            this.activity.startActivityForResult(galleryIntent, 1001);
        }
    }

    public File getFile(int resultCode, Intent data) {
        if (resultCode == -1) {
            Uri targetUri = data.getData();
            return new File(targetUri.getPath());
        }
        Log.e((String)this.TAG, (String)"Result Code was not OK");
        return null;
    }

    public Bitmap getBitmap(int resultCode, Intent data) {
        if (resultCode == -1) {
            Uri targetUri = data.getData();
            try {
                return BitmapFactory.decodeStream((InputStream)this.activity.getContentResolver().openInputStream(targetUri));
            }
            catch (FileNotFoundException e) {
                Log.e((String)this.TAG, (String)"File Not Found", (Throwable)e);
                return null;
            }
        }
        Log.e((String)this.TAG, (String)"Result Code was not OK");
        return null;
    }
}

