/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.android.library.audio;

import android.util.Log;
import com.ibm.watson.developer_cloud.android.library.audio.AmplitudeListener;
import com.ibm.watson.developer_cloud.android.library.audio.AudioConsumer;
import com.ibm.watson.developer_cloud.android.library.audio.MicrophoneCaptureThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public final class MicrophoneInputStream
extends InputStream
implements AudioConsumer {
    private static final String TAG = MicrophoneInputStream.class.getName();
    public static final String CONTENT_TYPE = "audio/l16;rate=16000";
    private final MicrophoneCaptureThread captureThread = new MicrophoneCaptureThread(this);
    private final PipedOutputStream os = new PipedOutputStream();
    private final PipedInputStream is = new PipedInputStream();
    private AmplitudeListener amplitudeListener;

    public MicrophoneInputStream() {
        try {
            this.is.connect(this.os);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        this.captureThread.start();
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("Call read(byte[]) or read(byte[], int, int)");
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.is.read(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.captureThread.end();
        this.os.close();
        this.is.close();
    }

    @Override
    public void consume(byte[] data, double amplitude, double volume) {
        if (this.amplitudeListener != null) {
            this.amplitudeListener.onSample(amplitude, volume);
        }
        try {
            this.os.write(data);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void setOnAmplitudeListener(AmplitudeListener listener) {
        this.amplitudeListener = listener;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }
}

