/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.android.library.audio;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class CameraHelper {
    private final String TAG = CameraHelper.class.getName();
    public static final int REQUEST_IMAGE_CAPTURE = 1000;
    private Activity activity;
    private String currentPhotoPath;

    public CameraHelper(Activity activity) {
        this.activity = activity;
    }

    public void dispatchTakePictureIntent() {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.activity.getPackageManager()) != null) {
            File photoFile = null;
            try {
                photoFile = this.createImageFile();
            }
            catch (IOException ex) {
                Log.e((String)this.TAG, (String)"IOException", (Throwable)ex);
            }
            if (photoFile != null) {
                takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)photoFile));
                this.activity.startActivityForResult(takePictureIntent, 1000);
            }
        }
    }

    private File createImageFile() throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        File image = File.createTempFile(imageFileName, ".jpg", storageDir);
        this.currentPhotoPath = "file:" + image.getAbsolutePath();
        return image;
    }

    public File getFile(int resultCode) {
        if (resultCode == -1) {
            Uri targetUri = Uri.parse((String)this.currentPhotoPath);
            return new File(targetUri.getPath());
        }
        Log.e((String)this.TAG, (String)"Result Code was not OK");
        return null;
    }

    public Bitmap getBitmap(int resultCode) {
        if (resultCode == -1) {
            Uri targetUri = Uri.parse((String)this.currentPhotoPath);
            try {
                return BitmapFactory.decodeStream((InputStream)this.activity.getContentResolver().openInputStream(targetUri));
            }
            catch (FileNotFoundException e) {
                Log.e((String)this.TAG, (String)"File Not Found", (Throwable)e);
                return null;
            }
        }
        Log.e((String)this.TAG, (String)"Result Code was not OK");
        return null;
    }
}

