/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.SearchSettings;
import java.util.Map;

public class UpdateSkillOptions
extends GenericModel {
    protected String assistantId;
    protected String skillId;
    protected String name;
    protected String description;
    protected Map<String, Object> workspace;
    protected Map<String, Object> dialogSettings;
    protected SearchSettings searchSettings;

    protected UpdateSkillOptions() {
    }

    protected UpdateSkillOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        Validator.notEmpty((String)builder.skillId, (String)"skillId cannot be empty");
        this.assistantId = builder.assistantId;
        this.skillId = builder.skillId;
        this.name = builder.name;
        this.description = builder.description;
        this.workspace = builder.workspace;
        this.dialogSettings = builder.dialogSettings;
        this.searchSettings = builder.searchSettings;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public String skillId() {
        return this.skillId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Map<String, Object> workspace() {
        return this.workspace;
    }

    public Map<String, Object> dialogSettings() {
        return this.dialogSettings;
    }

    public SearchSettings searchSettings() {
        return this.searchSettings;
    }

    public static class Builder {
        private String assistantId;
        private String skillId;
        private String name;
        private String description;
        private Map<String, Object> workspace;
        private Map<String, Object> dialogSettings;
        private SearchSettings searchSettings;

        private Builder(UpdateSkillOptions updateSkillOptions) {
            this.assistantId = updateSkillOptions.assistantId;
            this.skillId = updateSkillOptions.skillId;
            this.name = updateSkillOptions.name;
            this.description = updateSkillOptions.description;
            this.workspace = updateSkillOptions.workspace;
            this.dialogSettings = updateSkillOptions.dialogSettings;
            this.searchSettings = updateSkillOptions.searchSettings;
        }

        public Builder() {
        }

        public Builder(String assistantId, String skillId) {
            this.assistantId = assistantId;
            this.skillId = skillId;
        }

        public UpdateSkillOptions build() {
            return new UpdateSkillOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder workspace(Map<String, Object> workspace) {
            this.workspace = workspace;
            return this;
        }

        public Builder dialogSettings(Map<String, Object> dialogSettings) {
            this.dialogSettings = dialogSettings;
            return this;
        }

        public Builder searchSettings(SearchSettings searchSettings) {
            this.searchSettings = searchSettings;
            return this;
        }
    }
}

