/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.SearchSettings;
import com.ibm.watson.assistant.v2.model.SearchSkillWarning;
import com.ibm.watson.assistant.v2.model.StatusError;
import java.util.List;
import java.util.Map;

public class SkillImport
extends GenericModel {
    protected String name;
    protected String description;
    protected Map<String, Object> workspace;
    @SerializedName(value="skill_id")
    protected String skillId;
    protected String status;
    @SerializedName(value="status_errors")
    protected List<StatusError> statusErrors;
    @SerializedName(value="status_description")
    protected String statusDescription;
    @SerializedName(value="dialog_settings")
    protected Map<String, Object> dialogSettings;
    @SerializedName(value="assistant_id")
    protected String assistantId;
    @SerializedName(value="workspace_id")
    protected String workspaceId;
    @SerializedName(value="environment_id")
    protected String environmentId;
    protected Boolean valid;
    @SerializedName(value="next_snapshot_version")
    protected String nextSnapshotVersion;
    @SerializedName(value="search_settings")
    protected SearchSettings searchSettings;
    protected List<SearchSkillWarning> warnings;
    protected String language;
    protected String type;

    protected SkillImport() {
    }

    protected SkillImport(Builder builder) {
        Validator.notNull((Object)builder.language, (String)"language cannot be null");
        Validator.notNull((Object)builder.type, (String)"type cannot be null");
        this.name = builder.name;
        this.description = builder.description;
        this.workspace = builder.workspace;
        this.dialogSettings = builder.dialogSettings;
        this.searchSettings = builder.searchSettings;
        this.language = builder.language;
        this.type = builder.type;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Map<String, Object> workspace() {
        return this.workspace;
    }

    public String skillId() {
        return this.skillId;
    }

    public String status() {
        return this.status;
    }

    public List<StatusError> statusErrors() {
        return this.statusErrors;
    }

    public String statusDescription() {
        return this.statusDescription;
    }

    public Map<String, Object> dialogSettings() {
        return this.dialogSettings;
    }

    public String assistantId() {
        return this.assistantId;
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public Boolean valid() {
        return this.valid;
    }

    public String nextSnapshotVersion() {
        return this.nextSnapshotVersion;
    }

    public SearchSettings searchSettings() {
        return this.searchSettings;
    }

    public List<SearchSkillWarning> warnings() {
        return this.warnings;
    }

    public String language() {
        return this.language;
    }

    public String type() {
        return this.type;
    }

    public static class Builder {
        private String name;
        private String description;
        private Map<String, Object> workspace;
        private Map<String, Object> dialogSettings;
        private SearchSettings searchSettings;
        private String language;
        private String type;

        private Builder(SkillImport skillImport) {
            this.name = skillImport.name;
            this.description = skillImport.description;
            this.workspace = skillImport.workspace;
            this.dialogSettings = skillImport.dialogSettings;
            this.searchSettings = skillImport.searchSettings;
            this.language = skillImport.language;
            this.type = skillImport.type;
        }

        public Builder() {
        }

        public Builder(String language, String type) {
            this.language = language;
            this.type = type;
        }

        public SkillImport build() {
            return new SkillImport(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder workspace(Map<String, Object> workspace) {
            this.workspace = workspace;
            return this;
        }

        public Builder dialogSettings(Map<String, Object> dialogSettings) {
            this.dialogSettings = dialogSettings;
            return this;
        }

        public Builder searchSettings(SearchSettings searchSettings) {
            this.searchSettings = searchSettings;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }

    public static interface Type {
        public static final String ACTION = "action";
        public static final String DIALOG = "dialog";
        public static final String SEARCH = "search";
    }

    public static interface Status {
        public static final String AVAILABLE = "Available";
        public static final String FAILED = "Failed";
        public static final String NON_EXISTENT = "Non Existent";
        public static final String PROCESSING = "Processing";
        public static final String TRAINING = "Training";
        public static final String UNAVAILABLE = "Unavailable";
    }
}

