/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.SearchSettingsDiscoveryAuthentication;

public class SearchSettingsDiscovery
extends GenericModel {
    @SerializedName(value="instance_id")
    protected String instanceId;
    @SerializedName(value="project_id")
    protected String projectId;
    protected String url;
    @SerializedName(value="max_primary_results")
    protected Long maxPrimaryResults;
    @SerializedName(value="max_total_results")
    protected Long maxTotalResults;
    @SerializedName(value="confidence_threshold")
    protected Double confidenceThreshold;
    protected Boolean highlight;
    @SerializedName(value="find_answers")
    protected Boolean findAnswers;
    protected SearchSettingsDiscoveryAuthentication authentication;

    protected SearchSettingsDiscovery() {
    }

    protected SearchSettingsDiscovery(Builder builder) {
        Validator.notNull((Object)builder.instanceId, (String)"instanceId cannot be null");
        Validator.notNull((Object)builder.projectId, (String)"projectId cannot be null");
        Validator.notNull((Object)builder.url, (String)"url cannot be null");
        Validator.notNull((Object)((Object)builder.authentication), (String)"authentication cannot be null");
        this.instanceId = builder.instanceId;
        this.projectId = builder.projectId;
        this.url = builder.url;
        this.maxPrimaryResults = builder.maxPrimaryResults;
        this.maxTotalResults = builder.maxTotalResults;
        this.confidenceThreshold = builder.confidenceThreshold;
        this.highlight = builder.highlight;
        this.findAnswers = builder.findAnswers;
        this.authentication = builder.authentication;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String projectId() {
        return this.projectId;
    }

    public String url() {
        return this.url;
    }

    public Long maxPrimaryResults() {
        return this.maxPrimaryResults;
    }

    public Long maxTotalResults() {
        return this.maxTotalResults;
    }

    public Double confidenceThreshold() {
        return this.confidenceThreshold;
    }

    public Boolean highlight() {
        return this.highlight;
    }

    public Boolean findAnswers() {
        return this.findAnswers;
    }

    public SearchSettingsDiscoveryAuthentication authentication() {
        return this.authentication;
    }

    public static class Builder {
        private String instanceId;
        private String projectId;
        private String url;
        private Long maxPrimaryResults;
        private Long maxTotalResults;
        private Double confidenceThreshold;
        private Boolean highlight;
        private Boolean findAnswers;
        private SearchSettingsDiscoveryAuthentication authentication;

        private Builder(SearchSettingsDiscovery searchSettingsDiscovery) {
            this.instanceId = searchSettingsDiscovery.instanceId;
            this.projectId = searchSettingsDiscovery.projectId;
            this.url = searchSettingsDiscovery.url;
            this.maxPrimaryResults = searchSettingsDiscovery.maxPrimaryResults;
            this.maxTotalResults = searchSettingsDiscovery.maxTotalResults;
            this.confidenceThreshold = searchSettingsDiscovery.confidenceThreshold;
            this.highlight = searchSettingsDiscovery.highlight;
            this.findAnswers = searchSettingsDiscovery.findAnswers;
            this.authentication = searchSettingsDiscovery.authentication;
        }

        public Builder() {
        }

        public Builder(String instanceId, String projectId, String url, SearchSettingsDiscoveryAuthentication authentication) {
            this.instanceId = instanceId;
            this.projectId = projectId;
            this.url = url;
            this.authentication = authentication;
        }

        public SearchSettingsDiscovery build() {
            return new SearchSettingsDiscovery(this);
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder maxPrimaryResults(long maxPrimaryResults) {
            this.maxPrimaryResults = maxPrimaryResults;
            return this;
        }

        public Builder maxTotalResults(long maxTotalResults) {
            this.maxTotalResults = maxTotalResults;
            return this;
        }

        public Builder confidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        public Builder highlight(Boolean highlight) {
            this.highlight = highlight;
            return this;
        }

        public Builder findAnswers(Boolean findAnswers) {
            this.findAnswers = findAnswers;
            return this;
        }

        public Builder authentication(SearchSettingsDiscoveryAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }
    }
}

