/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.SearchSettingsDiscovery;
import com.ibm.watson.assistant.v2.model.SearchSettingsMessages;
import com.ibm.watson.assistant.v2.model.SearchSettingsSchemaMapping;

public class SearchSettings
extends GenericModel {
    protected SearchSettingsDiscovery discovery;
    protected SearchSettingsMessages messages;
    @SerializedName(value="schema_mapping")
    protected SearchSettingsSchemaMapping schemaMapping;

    protected SearchSettings() {
    }

    protected SearchSettings(Builder builder) {
        Validator.notNull((Object)((Object)builder.discovery), (String)"discovery cannot be null");
        Validator.notNull((Object)((Object)builder.messages), (String)"messages cannot be null");
        Validator.notNull((Object)((Object)builder.schemaMapping), (String)"schemaMapping cannot be null");
        this.discovery = builder.discovery;
        this.messages = builder.messages;
        this.schemaMapping = builder.schemaMapping;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public SearchSettingsDiscovery discovery() {
        return this.discovery;
    }

    public SearchSettingsMessages messages() {
        return this.messages;
    }

    public SearchSettingsSchemaMapping schemaMapping() {
        return this.schemaMapping;
    }

    public static class Builder {
        private SearchSettingsDiscovery discovery;
        private SearchSettingsMessages messages;
        private SearchSettingsSchemaMapping schemaMapping;

        private Builder(SearchSettings searchSettings) {
            this.discovery = searchSettings.discovery;
            this.messages = searchSettings.messages;
            this.schemaMapping = searchSettings.schemaMapping;
        }

        public Builder() {
        }

        public Builder(SearchSettingsDiscovery discovery, SearchSettingsMessages messages, SearchSettingsSchemaMapping schemaMapping) {
            this.discovery = discovery;
            this.messages = messages;
            this.schemaMapping = schemaMapping;
        }

        public SearchSettings build() {
            return new SearchSettings(this);
        }

        public Builder discovery(SearchSettingsDiscovery discovery) {
            this.discovery = discovery;
            return this;
        }

        public Builder messages(SearchSettingsMessages messages) {
            this.messages = messages;
            return this;
        }

        public Builder schemaMapping(SearchSettingsSchemaMapping schemaMapping) {
            this.schemaMapping = schemaMapping;
            return this;
        }
    }
}

