/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.AssistantState;
import com.ibm.watson.assistant.v2.model.SkillImport;
import java.util.ArrayList;
import java.util.List;

public class ImportSkillsOptions
extends GenericModel {
    protected String assistantId;
    protected List<SkillImport> assistantSkills;
    protected AssistantState assistantState;
    protected Boolean includeAudit;

    protected ImportSkillsOptions() {
    }

    protected ImportSkillsOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        Validator.notNull((Object)builder.assistantSkills, (String)"assistantSkills cannot be null");
        Validator.notNull((Object)((Object)builder.assistantState), (String)"assistantState cannot be null");
        this.assistantId = builder.assistantId;
        this.assistantSkills = builder.assistantSkills;
        this.assistantState = builder.assistantState;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public List<SkillImport> assistantSkills() {
        return this.assistantSkills;
    }

    public AssistantState assistantState() {
        return this.assistantState;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String assistantId;
        private List<SkillImport> assistantSkills;
        private AssistantState assistantState;
        private Boolean includeAudit;

        private Builder(ImportSkillsOptions importSkillsOptions) {
            this.assistantId = importSkillsOptions.assistantId;
            this.assistantSkills = importSkillsOptions.assistantSkills;
            this.assistantState = importSkillsOptions.assistantState;
            this.includeAudit = importSkillsOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String assistantId, List<SkillImport> assistantSkills, AssistantState assistantState) {
            this.assistantId = assistantId;
            this.assistantSkills = assistantSkills;
            this.assistantState = assistantState;
        }

        public ImportSkillsOptions build() {
            return new ImportSkillsOptions(this);
        }

        public Builder addAssistantSkills(SkillImport assistantSkills) {
            Validator.notNull((Object)((Object)assistantSkills), (String)"assistantSkills cannot be null");
            if (this.assistantSkills == null) {
                this.assistantSkills = new ArrayList<SkillImport>();
            }
            this.assistantSkills.add(assistantSkills);
            return this;
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder assistantSkills(List<SkillImport> assistantSkills) {
            this.assistantSkills = assistantSkills;
            return this;
        }

        public Builder assistantState(AssistantState assistantState) {
            this.assistantState = assistantState;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

