/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class GetEnvironmentOptions
extends GenericModel {
    protected String assistantId;
    protected String environmentId;
    protected Boolean includeAudit;

    protected GetEnvironmentOptions() {
    }

    protected GetEnvironmentOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        this.assistantId = builder.assistantId;
        this.environmentId = builder.environmentId;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String assistantId;
        private String environmentId;
        private Boolean includeAudit;

        private Builder(GetEnvironmentOptions getEnvironmentOptions) {
            this.assistantId = getEnvironmentOptions.assistantId;
            this.environmentId = getEnvironmentOptions.environmentId;
            this.includeAudit = getEnvironmentOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String assistantId, String environmentId) {
            this.assistantId = assistantId;
            this.environmentId = environmentId;
        }

        public GetEnvironmentOptions build() {
            return new GetEnvironmentOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

