/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.WebhookHeader;
import java.util.ArrayList;
import java.util.List;

public class Webhook
extends GenericModel {
    protected String url;
    protected String name;
    protected List<WebhookHeader> headers;

    protected Webhook() {
    }

    protected Webhook(Builder builder) {
        Validator.notNull((Object)builder.url, (String)"url cannot be null");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        this.url = builder.url;
        this.name = builder.name;
        this.headers = builder.headers;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String url() {
        return this.url;
    }

    public String name() {
        return this.name;
    }

    public List<WebhookHeader> headers() {
        return this.headers;
    }

    public static class Builder {
        private String url;
        private String name;
        private List<WebhookHeader> headers;

        private Builder(Webhook webhook) {
            this.url = webhook.url;
            this.name = webhook.name;
            this.headers = webhook.headers;
        }

        public Builder() {
        }

        public Builder(String url, String name) {
            this.url = url;
            this.name = name;
        }

        public Webhook build() {
            return new Webhook(this);
        }

        public Builder addHeaders(WebhookHeader headers) {
            Validator.notNull((Object)((Object)headers), (String)"headers cannot be null");
            if (this.headers == null) {
                this.headers = new ArrayList<WebhookHeader>();
            }
            this.headers.add(headers);
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder headers(List<WebhookHeader> headers) {
            this.headers = headers;
            return this;
        }
    }
}

