/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.Counterexample;
import com.ibm.watson.assistant.v1.model.CreateEntity;
import com.ibm.watson.assistant.v1.model.CreateIntent;
import com.ibm.watson.assistant.v1.model.DialogNode;
import com.ibm.watson.assistant.v1.model.Webhook;
import com.ibm.watson.assistant.v1.model.WorkspaceSystemSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateWorkspaceAsyncOptions
extends GenericModel {
    protected String workspaceId;
    protected String name;
    protected String description;
    protected String language;
    protected List<DialogNode> dialogNodes;
    protected List<Counterexample> counterexamples;
    protected Map<String, Object> metadata;
    protected Boolean learningOptOut;
    protected WorkspaceSystemSettings systemSettings;
    protected List<Webhook> webhooks;
    protected List<CreateIntent> intents;
    protected List<CreateEntity> entities;
    protected Boolean append;

    protected UpdateWorkspaceAsyncOptions() {
    }

    protected UpdateWorkspaceAsyncOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.name = builder.name;
        this.description = builder.description;
        this.language = builder.language;
        this.dialogNodes = builder.dialogNodes;
        this.counterexamples = builder.counterexamples;
        this.metadata = builder.metadata;
        this.learningOptOut = builder.learningOptOut;
        this.systemSettings = builder.systemSettings;
        this.webhooks = builder.webhooks;
        this.intents = builder.intents;
        this.entities = builder.entities;
        this.append = builder.append;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String language() {
        return this.language;
    }

    public List<DialogNode> dialogNodes() {
        return this.dialogNodes;
    }

    public List<Counterexample> counterexamples() {
        return this.counterexamples;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public Boolean learningOptOut() {
        return this.learningOptOut;
    }

    public WorkspaceSystemSettings systemSettings() {
        return this.systemSettings;
    }

    public List<Webhook> webhooks() {
        return this.webhooks;
    }

    public List<CreateIntent> intents() {
        return this.intents;
    }

    public List<CreateEntity> entities() {
        return this.entities;
    }

    public Boolean append() {
        return this.append;
    }

    public static class Builder {
        private String workspaceId;
        private String name;
        private String description;
        private String language;
        private List<DialogNode> dialogNodes;
        private List<Counterexample> counterexamples;
        private Map<String, Object> metadata;
        private Boolean learningOptOut;
        private WorkspaceSystemSettings systemSettings;
        private List<Webhook> webhooks;
        private List<CreateIntent> intents;
        private List<CreateEntity> entities;
        private Boolean append;

        private Builder(UpdateWorkspaceAsyncOptions updateWorkspaceAsyncOptions) {
            this.workspaceId = updateWorkspaceAsyncOptions.workspaceId;
            this.name = updateWorkspaceAsyncOptions.name;
            this.description = updateWorkspaceAsyncOptions.description;
            this.language = updateWorkspaceAsyncOptions.language;
            this.dialogNodes = updateWorkspaceAsyncOptions.dialogNodes;
            this.counterexamples = updateWorkspaceAsyncOptions.counterexamples;
            this.metadata = updateWorkspaceAsyncOptions.metadata;
            this.learningOptOut = updateWorkspaceAsyncOptions.learningOptOut;
            this.systemSettings = updateWorkspaceAsyncOptions.systemSettings;
            this.webhooks = updateWorkspaceAsyncOptions.webhooks;
            this.intents = updateWorkspaceAsyncOptions.intents;
            this.entities = updateWorkspaceAsyncOptions.entities;
            this.append = updateWorkspaceAsyncOptions.append;
        }

        public Builder() {
        }

        public Builder(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public UpdateWorkspaceAsyncOptions build() {
            return new UpdateWorkspaceAsyncOptions(this);
        }

        public Builder addDialogNode(DialogNode dialogNode) {
            Validator.notNull((Object)((Object)dialogNode), (String)"dialogNode cannot be null");
            if (this.dialogNodes == null) {
                this.dialogNodes = new ArrayList<DialogNode>();
            }
            this.dialogNodes.add(dialogNode);
            return this;
        }

        public Builder addCounterexample(Counterexample counterexample) {
            Validator.notNull((Object)((Object)counterexample), (String)"counterexample cannot be null");
            if (this.counterexamples == null) {
                this.counterexamples = new ArrayList<Counterexample>();
            }
            this.counterexamples.add(counterexample);
            return this;
        }

        public Builder addWebhooks(Webhook webhooks) {
            Validator.notNull((Object)((Object)webhooks), (String)"webhooks cannot be null");
            if (this.webhooks == null) {
                this.webhooks = new ArrayList<Webhook>();
            }
            this.webhooks.add(webhooks);
            return this;
        }

        public Builder addIntent(CreateIntent intent) {
            Validator.notNull((Object)((Object)intent), (String)"intent cannot be null");
            if (this.intents == null) {
                this.intents = new ArrayList<CreateIntent>();
            }
            this.intents.add(intent);
            return this;
        }

        public Builder addEntity(CreateEntity entity) {
            Validator.notNull((Object)((Object)entity), (String)"entity cannot be null");
            if (this.entities == null) {
                this.entities = new ArrayList<CreateEntity>();
            }
            this.entities.add(entity);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder dialogNodes(List<DialogNode> dialogNodes) {
            this.dialogNodes = dialogNodes;
            return this;
        }

        public Builder counterexamples(List<Counterexample> counterexamples) {
            this.counterexamples = counterexamples;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder learningOptOut(Boolean learningOptOut) {
            this.learningOptOut = learningOptOut;
            return this;
        }

        public Builder systemSettings(WorkspaceSystemSettings systemSettings) {
            this.systemSettings = systemSettings;
            return this;
        }

        public Builder webhooks(List<Webhook> webhooks) {
            this.webhooks = webhooks;
            return this;
        }

        public Builder intents(List<CreateIntent> intents) {
            this.intents = intents;
            return this;
        }

        public Builder entities(List<CreateEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder append(Boolean append) {
            this.append = append;
            return this;
        }
    }
}

