/* Generated By:JavaCC: Do not edit this line. Json.java */
package com.ibm.commons.util.io.json.parser;

import com.ibm.commons.util.io.json.*;
import java.util.*;

/**
 *
 */
public class Json implements JsonConstants {

        public JsonFactory factory;

        public String getStringValue(String image) throws ParseException {
                int l = image.length()-1; // Leading & trailing quotes, see loop index starting at 1...
                StringBuilder sb = new StringBuilder(l);
                for (int i = 1; i < l; i++) {
                        char c = image.charAt(i);
                        if (c == '\u005c\u005c') {
                                i++;
                                if(i<l) {
                                        c = image.charAt(i);
                                        if (c == 'n')
                                                c = '\u005cn';
                                        else if (c == 'b')
                                                c = '\u005cb';
                                        else if (c == 'f')
                                                c = '\u005cf';
                                        else if (c == 'r')
                                                c = '\u005cr';
                                        else if (c == 't')
                                                c = '\u005ct';
                                        else if (c == 'v')
                                                c = 0x000b;
                                        else if (c == 'x' && i+2<l && isHexaDigit(image.charAt(i+1)) && isHexaDigit(image.charAt(i+2))) {
                                                c = (char) (hexval(image.charAt(i+1)) << 4
                                                                  | hexval(image.charAt(i+2)));
                                                i += 2;
                                        } else if (c == 'u' && i+4<l && isHexaDigit(image.charAt(i+1)) && isHexaDigit(image.charAt(i+2)) && isHexaDigit(image.charAt(i+3)) && isHexaDigit(image.charAt(i+4))) {
                                                c = (char) (hexval(image.charAt(i+1)) << 12
                                                                  | hexval(image.charAt(i+2)) << 8
                                                                  | hexval(image.charAt(i+3)) << 4
                                                                  | hexval(image.charAt(i+4)));
                                                i += 4;
                                        } else if ( i+1<l && isOctalDigit(c) && isOctalDigit(image.charAt(i+1)) ) {
                                                c = (char) (octval(c) << 3
                                                          | octval(image.charAt(i+1)));
                                                i += 1;
                                        }
                                }
                        }
                        sb.append(c);
                }
                return sb.toString();
        }
        private static boolean isOctalDigit(char c) {
                return c>='0' && c<='7';
        }
        private static boolean isHexaDigit(char c) {
                return (c>='0' && c<='9') || (c>='A' && c<='F') || (c>='a' && c<='f');
        }
        private static int hexval(char c) throws ParseException {
                switch (c) {
                        case '0':
                                return 0;
                        case '1':
                                return 1;
                        case '2':
                                return 2;
                        case '3':
                                return 3;
                        case '4':
                                return 4;
                        case '5':
                                return 5;
                        case '6':
                                return 6;
                        case '7':
                                return 7;
                        case '8':
                                return 8;
                        case '9':
                                return 9;

                        case 'a':
                        case 'A':
                                return 10;
                        case 'b':
                        case 'B':
                                return 11;
                        case 'c':
                        case 'C':
                                return 12;
                        case 'd':
                        case 'D':
                                return 13;
                        case 'e':
                        case 'E':
                                return 14;
                        case 'f':
                        case 'F':
                                return 15;
                }
        throw new ParseException("Internal error when evaluating hexadecimal escape sequence");
        }
        private static int octval(char c) throws ParseException {
                switch (c) {
                        case '0':
                                return 0;
                        case '1':
                                return 1;
                        case '2':
                                return 2;
                        case '3':
                                return 3;
                        case '4':
                                return 4;
                        case '5':
                                return 5;
                        case '6':
                                return 6;
                        case '7':
                                return 7;
                        case '8':
                                return 8;
                        case '9':
                                return 9;
                }
        throw new ParseException("Internal error when evaluating octal escape sequence"); 
        }

  final public Object nullLiteral() throws ParseException, JsonException {
    jj_consume_token(NULL);
                {if (true) return factory.createNull();}
    throw new Error("Missing return statement in function");
  }

  final public Object booleanLiteral() throws ParseException, JsonException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
                  {if (true) return factory.createBoolean(true);}
      break;
    case FALSE:
      jj_consume_token(FALSE);
                  {if (true) return factory.createBoolean(false);}
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Object numericLiteral() throws ParseException, JsonException {
     Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      t = jj_consume_token(INTEGER_LITERAL);
                String image=t.image;
                if (image.startsWith("0x") || image.startsWith("0X") ) {
                                String imageWithout0x = image.substring(2);
                                {if (true) return factory.createNumber((Long.parseLong(imageWithout0x, 16)));}
                } else if (image.startsWith("0") && !image.equals("0") && !image.startsWith("0.") ){
                                String imageWithout0 = image.length()>1 ? image.substring(1) : image;
                                {if (true) return factory.createNumber((Long.parseLong(imageWithout0, 8)));}
                } else {
                                {if (true) return factory.createNumber((Double.parseDouble(image)));}
                }
      break;
    case FLOATING_POINT_LITERAL:
      t = jj_consume_token(FLOATING_POINT_LITERAL);
                        {if (true) return factory.createNumber((Double.parseDouble(t.image)));}
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Object stringLiteral() throws ParseException, JsonException {
     Token t;
    t = jj_consume_token(STRING_LITERAL);
            {if (true) return factory.createString(getStringValue(t.image));}
    throw new Error("Missing return statement in function");
  }

  final public Object literal(Object parent, String property) throws ParseException, JsonException {
     Object value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      value = nullLiteral();
      break;
    case FALSE:
    case TRUE:
      value = booleanLiteral();
      break;
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
      value = numericLiteral();
      break;
    case STRING_LITERAL:
      value = stringLiteral();
      break;
    case LBRACE:
      value = objectLiteral(parent,property);
      break;
    case LBRACKET:
      value = arrayLiteral(parent,property);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public Object objectLiteral(Object parent, String property) throws ParseException, JsonException {
         Object object;
    jj_consume_token(LBRACE);
                          object = factory.createObject(parent,property);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
    case IDENTIFIER:
      propertyNameAndValueList(object);
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
                         {if (true) return object;}
    throw new Error("Missing return statement in function");
  }

  final public void propertyNameAndValueList(Object parent) throws ParseException, JsonException {
     String name; Object value;
    name = propertyName();
    jj_consume_token(COLON);
    value = literal(parent,name);
          factory.setProperty(parent, name, value);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_1;
      }
      jj_consume_token(COMMA);
      name = propertyName();
      jj_consume_token(COLON);
      value = literal(parent,name);
          factory.setProperty(parent, name, value);
    }
  }

  final public String propertyName() throws ParseException {
     Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      // JSON extension: we support identifier not enquoted
               t = jj_consume_token(IDENTIFIER);
            {if (true) return t.image;}
      break;
    case STRING_LITERAL:
      t = jj_consume_token(STRING_LITERAL);
            {if (true) return getStringValue(t.image);}
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Object arrayLiteral(Object parent, String property) throws ParseException, JsonException {
         List<Object> array;
     int count=0;
    jj_consume_token(LBRACKET);
             array = factory.createTemporaryArray(parent);
    count = elision();
           for(int i=0; i<count; i++) {
                  array.add(factory.createNull());
           }
    elementList(parent,property,array);
            // if the elementList(anode) did not add any members to the array
            // => the array is like [,,,,] so we must add an empty member at the end.
                        int cnt = array.size();
            if(cnt==count && count!=0){
                        array.add(factory.createNull());
            }
    jj_consume_token(RBRACKET);
            {if (true) return factory.createArray(parent,property,array);}
    throw new Error("Missing return statement in function");
  }

  final public void elementList(Object parent, String property, List<Object> array) throws ParseException, JsonException {
     int count=0; Object value;
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FALSE:
      case NULL:
      case TRUE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case LBRACE:
      case LBRACKET:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_2;
      }
      value = literal(parent,property);
                  array.add(value);
      count = elision();
                if(count>0) {
                        for(int i=0; i<count-1; i++) {
                                array.add(factory.createNull());
                        }
                }
    }
          if(count>0){// take the last ',' into account
                array.add(factory.createNull());
          }
  }

  final public int elision() throws ParseException {
     int count=0;
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
           count++;
    }
            {if (true) return count;}
    throw new Error("Missing return statement in function");
  }

  final public Object parseJsonLiteral() throws ParseException, JsonException {
     Object object;
    object = literal(null,null);
                 {if (true) return object;}
    throw new Error("Missing return statement in function");
  }

  final public Object parseJson() throws ParseException, JsonException {
     Object object;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      object = objectLiteral(null,null);
      break;
    case LBRACKET:
      object = arrayLiteral(null,null);
      break;
    case NULL:
      object = nullLiteral();
      break;
    case FALSE:
    case TRUE:
      object = booleanLiteral();
      break;
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
      object = numericLiteral();
      break;
    case STRING_LITERAL:
      object = stringLiteral();
      break;
    case 33:
      jj_consume_token(33);
      object = parseJson();
      jj_consume_token(34);
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return object;}
    throw new Error("Missing return statement in function");
  }

  final public void parseJsonList(List list) throws ParseException, JsonException {
      Object value;
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FALSE:
      case NULL:
      case TRUE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case LBRACE:
      case LBRACKET:
      case 33:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_4;
      }
      value = parseJson();
                        if(list!=null) {
                                        list.add(value);
                                }
    }
    jj_consume_token(0);
  }

  final public void parseJsonCallback(com.ibm.commons.util.io.json.JsonParser.ParseCallback callback) throws ParseException, JsonException {
      Object value;
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FALSE:
      case NULL:
      case TRUE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case LBRACE:
      case LBRACKET:
      case 33:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_5;
      }
      value = parseJson();
                        if(callback!=null) {
                                        callback.jsonEntry(value);
                                }
    }
    jj_consume_token(0);
  }

  /** Generated Token Manager. */
  public JsonTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[11];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0xa000,0x110000,0x2851e000,0x1400000,0x0,0x1400000,0x2851e000,0x0,0x2851e000,0x2851e000,0x2851e000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x1,0x2,0x2,0x2,};
   }

  /** Constructor with InputStream. */
  public Json(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public Json(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new JsonTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 11; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 11; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public Json(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new JsonTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 11; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 11; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public Json(JsonTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 11; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(JsonTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 11; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[35];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 11; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 35; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
