/*
 * © Copyright IBM Corp. 2012-2013
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at:
 * 
 * http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing 
 * permissions and limitations under the License.
 */

package com.ibm.commons.log;

/**
 * Those are predefined log groups for developers.
 * 
 * This is for IBM internal use only.
 * 
 * @ibm-not-published
 */
public class DevLog extends Log {
    // Andre Guirard
    public static final LogMgr AGUIRARD = loadDev("aguirard"); // $NON-NLS-1$

    // Ameet Kulkarni
    public static final LogMgr AKULKARN = loadDev("akulkarn"); // $NON-NLS-1$

    // Chris Lowe
    public static final LogMgr CLLOWE   = loadDev("cllowe"); // $NON-NLS-1$

    // Dan O'Connor
    public static final LogMgr DOCONNOR = loadDev("doconnor"); // $NON-NLS-1$

    // Maureen Leland
    public static final LogMgr MGL      = loadDev("mgl"); // $NON-NLS-1$

    // Philippe Riand
    public static final LogMgr PHIL     = loadDev("phil");// Philippe Riand $NON-NLS-1$
    
    // Ishfak Bhagat
    public static final LogMgr ISHFAK   = loadDev("ishfak"); // $NON-NLS-1$

    // Santosh Kumar
    public static final LogMgr SKUMAR   = loadDev("skumar"); // $NON-NLS-1$
    
    // Girish Baxi
    public static final LogMgr GIRIBAXI  = loadDev("giribaxi"); // $NON-NLS-1$
    
    // Piyush Mishra
    public static final LogMgr MPIYUSH  = loadDev("mpiyushi"); // $NON-NLS-1$
    
    // Isha Deshpande
    public static final LogMgr ISHA    = loadDev("isha"); // $NON-NLS-1$
    
    // Steve Leland
    public static final LogMgr OSL		= loadDev("osl"); // $NON-NLS-1$
    
    // Graham O'Keeffe
    public static final LogMgr GOK		= loadDev("gok"); // $NON-NLS-1$
    
}