/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.spring.boot.MQConfigurationProperties;
import com.ibm.mq.spring.boot.MQConfigurationPropertiesJndi;
import com.ibm.mq.spring.boot.MQConnectionFactoryCustomizer;
import com.ibm.msg.client.wmq.WMQConstants;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQConnectionFactoryFactory {
    private final MQConfigurationProperties properties;
    private final List<MQConnectionFactoryCustomizer> factoryCustomizers;
    private static Logger logger = LoggerFactory.getLogger(MQConnectionFactoryFactory.class);

    public MQConnectionFactoryFactory(MQConfigurationProperties properties, List<MQConnectionFactoryCustomizer> factoryCustomizers) {
        this.properties = properties;
        this.factoryCustomizers = factoryCustomizers != null ? factoryCustomizers : Collections.emptyList();
        logger.trace("constructor");
    }

    public <T extends MQConnectionFactory> T createConnectionFactory(Class<T> factoryClass) {
        String err = null;
        MQConnectionFactory cf = null;
        String jndiProviderUrl = this.properties.getJndi().getProviderUrl();
        String jndiCF = this.properties.getJndi().getProviderContextFactory();
        logger.trace("createConnectionFactory for class " + factoryClass.getSimpleName());
        if (MQConnectionFactoryFactory.isNotNullOrEmpty(jndiProviderUrl) && MQConnectionFactoryFactory.isNotNullOrEmpty(jndiCF)) {
            logger.trace("createConnectionFactory using JNDI");
            try {
                String cfName = this.properties.getQueueManager();
                this.properties.getJndi().traceProperties(cfName);
                Context ctx = MQConnectionFactoryFactory.getJndiContext(this.properties.getJndi());
                cf = jndiProviderUrl.toUpperCase().contains("LDAP") && !cfName.toUpperCase().startsWith("CN=") ? (MQConnectionFactory)ctx.lookup("cn=" + cfName) : (MQConnectionFactory)ctx.lookup(cfName);
                this.customize(cf);
            }
            catch (NamingException ex) {
                logger.trace("createConnectionFactory : exception " + ex.getMessage());
                throw new IllegalStateException("Unable to create MQConnectionFactory" + (err != null ? ": " + err : ""), ex);
            }
        }
        try {
            cf = (MQConnectionFactory)this.createConnectionFactoryInstance(factoryClass);
            MQConnectionFactoryFactory.configureConnectionFactory(cf, this.properties);
            this.customize(cf);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | JMSException ex) {
            logger.trace("createConnectionFactory : exception " + ex.getMessage());
            throw new IllegalStateException("Unable to create MQConnectionFactory" + (err != null ? ": " + err : ""), ex);
        }
        return (T)cf;
    }

    public static void configureConnectionFactory(MQConnectionFactory cf, MQConfigurationProperties props) throws JMSException {
        String u;
        String applicationName;
        logger.trace("configureConnectionFactory");
        props.traceProperties();
        String qmName = props.getQueueManager();
        cf.setStringProperty("XMSC_WMQ_QUEUE_MANAGER", qmName);
        String channel = props.getChannel();
        String connName = props.getConnName();
        String ccdtUrl = props.getCcdtUrl();
        if (!MQConnectionFactoryFactory.isNullOrEmpty(ccdtUrl)) {
            cf.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
            cf.setStringProperty("XMSC_WMQ_CCDTURL", ccdtUrl);
        } else if (MQConnectionFactoryFactory.isNullOrEmpty(channel) || MQConnectionFactoryFactory.isNullOrEmpty(connName)) {
            cf.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 0);
        } else {
            cf.setStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST", connName);
            cf.setStringProperty("XMSC_WMQ_CHANNEL", channel);
            cf.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
        }
        String clientId = props.getClientId();
        if (!MQConnectionFactoryFactory.isNullOrEmpty(clientId)) {
            cf.setStringProperty("XMSC_CLIENT_ID", clientId);
        }
        if (!MQConnectionFactoryFactory.isNullOrEmpty(applicationName = props.getApplicationName())) {
            cf.setAppName(applicationName);
        }
        if (!MQConnectionFactoryFactory.isNullOrEmpty(u = props.getUser())) {
            cf.setStringProperty("XMSC_USERID", u);
            String p = props.getPassword();
            if (!MQConnectionFactoryFactory.isNullOrEmpty(p)) {
                cf.setStringProperty("XMSC_PASSWORD", p);
            }
            cf.setBooleanProperty("XMSC_USER_AUTHENTICATION_MQCSP", props.isUserAuthenticationMQCSP());
        }
        if (!MQConnectionFactoryFactory.isNullOrEmpty(props.getSslCipherSuite())) {
            cf.setStringProperty("XMSC_WMQ_SSL_CIPHER_SUITE", props.getSslCipherSuite());
        }
        if (!MQConnectionFactoryFactory.isNullOrEmpty(props.getSslCipherSpec())) {
            cf.setStringProperty("XMSC_WMQ_SSL_CIPHER_SPEC", props.getSslCipherSpec());
        }
        if (!MQConnectionFactoryFactory.isNullOrEmpty(props.getSslPeerName())) {
            cf.setStringProperty("XMSC_WMQ_SSL_PEER_NAME", props.getSslPeerName());
        }
        cf.setBooleanProperty("XMSC_WMQ_SSL_FIPS_REQUIRED", props.isSslFIPSRequired());
        Integer vi = props.getSslKeyResetCount();
        if (vi != -1) {
            cf.setIntProperty("XMSC_WMQ_SSL_KEY_RESETCOUNT", vi.intValue());
        }
        if (!MQConnectionFactoryFactory.isNullOrEmpty(props.getTempQPrefix())) {
            cf.setStringProperty("XMSC_WMQ_TEMP_Q_PREFIX", props.getTempQPrefix());
        }
        if (!MQConnectionFactoryFactory.isNullOrEmpty(props.getTempTopicPrefix())) {
            cf.setStringProperty("XMSC_WMQ_TEMP_TOPIC_PREFIX", props.getTempTopicPrefix());
        }
        if (!MQConnectionFactoryFactory.isNullOrEmpty(props.getTempModel())) {
            cf.setStringProperty("XMSC_WMQ_TEMPORARY_MODEL", props.getTempModel());
        }
        Map<String, String> additionalProperties = props.getAdditionalProperties();
        for (String k : additionalProperties.keySet()) {
            String v = additionalProperties.get(k);
            Boolean vb = null;
            vi = null;
            String key = k;
            if (key.startsWith("WMQ_")) {
                try {
                    Object o;
                    Field f = WMQConstants.class.getField(key);
                    if (f != null && (o = f.get(new Object())) != null && o instanceof String) {
                        key = (String)o;
                        logger.trace("Successfully mapped {} to property name {}", (Object)k, (Object)key);
                    }
                }
                catch (Throwable e) {
                    logger.warn("Cannot find value of property " + k, e);
                }
            }
            try {
                vi = v.toUpperCase().startsWith("0X") ? Integer.decode(v) : Integer.valueOf(v);
                cf.setIntProperty(key, vi.intValue());
                logger.trace("Using setIntProperty with key {} and value {} [{}]", new Object[]{key, vi, String.format("0x%08X", vi)});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (vi == null && (v.toUpperCase().equals("TRUE") || v.toUpperCase().equals("FALSE"))) {
                vb = Boolean.valueOf(v);
                cf.setBooleanProperty(key, vb.booleanValue());
                logger.trace("Using setBooleanProperty with key {} and value {}", (Object)key, (Object)vb);
            }
            if (vi != null || vb != null) continue;
            cf.setStringProperty(key, v);
            logger.trace("Using setStringProperty with key {} and value {}", (Object)key, (Object)v);
        }
    }

    private <T extends MQConnectionFactory> T createConnectionFactoryInstance(Class<T> factoryClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        logger.trace("createConnectionFactoryInstance for class " + factoryClass.getSimpleName());
        return (T)((MQConnectionFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    private void customize(MQConnectionFactory connectionFactory) {
        for (MQConnectionFactoryCustomizer factoryCustomizer : this.factoryCustomizers) {
            logger.trace("Calling MQConnectionFactoryCustomizer from class {} ", (Object)factoryCustomizer.getClass().getName());
            factoryCustomizer.customize(connectionFactory);
        }
    }

    public static Context getJndiContext(MQConfigurationPropertiesJndi jproperties) throws NamingException {
        logger.trace("getJndiContext");
        String jndiProviderUrl = jproperties.getProviderUrl();
        String jndiCF = jproperties.getProviderContextFactory();
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.provider.url", jndiProviderUrl);
        environment.put("java.naming.factory.initial", jndiCF);
        Map<String, String> additionalProperties = jproperties.getAdditionalProperties();
        for (String k : additionalProperties.keySet()) {
            String v = additionalProperties.get(k);
            try {
                Object o;
                Field f = Context.class.getField(k);
                if (f != null && (o = f.get(new Object())) != null && o instanceof String) {
                    k = (String)o;
                }
            }
            catch (Throwable e) {
                logger.warn("Cannot find value of property " + k);
            }
            logger.trace(String.format("getJndiContext: Using additional property '%s' with value '%s'", k, v));
            environment.put(k, v);
        }
        InitialDirContext ctx = new InitialDirContext(environment);
        return ctx;
    }

    static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    static boolean isNotNullOrEmpty(String s) {
        return !MQConnectionFactoryFactory.isNullOrEmpty(s);
    }
}

