/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.spring.boot.MQConfigurationProperties;
import com.ibm.mq.spring.boot.MQConnectionFactoryCustomizer;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;

public class MQConnectionFactoryFactory {
    private final MQConfigurationProperties properties;
    private final List<MQConnectionFactoryCustomizer> factoryCustomizers;

    public MQConnectionFactoryFactory(MQConfigurationProperties properties, List<MQConnectionFactoryCustomizer> factoryCustomizers) {
        this.properties = properties;
        this.factoryCustomizers = factoryCustomizers != null ? factoryCustomizers : Collections.emptyList();
    }

    public <T extends MQConnectionFactory> T createConnectionFactory(Class<T> factoryClass) {
        String err = null;
        try {
            String u;
            String applicationName;
            T cf = this.createConnectionFactoryInstance(factoryClass);
            String qmName = this.properties.getQueueManager();
            cf.setStringProperty("XMSC_WMQ_QUEUE_MANAGER", qmName);
            String channel = this.properties.getChannel();
            String connName = this.properties.getConnName();
            String ccdtUrl = this.properties.getCcdtUrl();
            if (!this.isNullOrEmpty(ccdtUrl)) {
                cf.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
                cf.setStringProperty("XMSC_WMQ_CCDTURL", ccdtUrl);
            } else if (this.isNullOrEmpty(channel) || this.isNullOrEmpty(connName)) {
                cf.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 0);
            } else {
                cf.setStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST", connName);
                cf.setStringProperty("XMSC_WMQ_CHANNEL", channel);
                cf.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
            }
            String clientId = this.properties.getClientId();
            if (!this.isNullOrEmpty(clientId)) {
                cf.setStringProperty("XMSC_CLIENT_ID", clientId);
            }
            if (!this.isNullOrEmpty(applicationName = this.properties.getApplicationName())) {
                cf.setAppName(applicationName);
            }
            if (!this.isNullOrEmpty(u = this.properties.getUser())) {
                cf.setStringProperty("XMSC_USERID", u);
                String p = this.properties.getPassword();
                if (!this.isNullOrEmpty(p)) {
                    cf.setStringProperty("XMSC_PASSWORD", p);
                }
                cf.setBooleanProperty("XMSC_USER_AUTHENTICATION_MQCSP", this.properties.isUserAuthenticationMQCSP());
            }
            if (!this.isNullOrEmpty(this.properties.getSslCipherSuite())) {
                cf.setStringProperty("XMSC_WMQ_SSL_CIPHER_SUITE", this.properties.getSslCipherSuite());
            }
            if (!this.isNullOrEmpty(this.properties.getSslCipherSpec())) {
                cf.setStringProperty("XMSC_WMQ_SSL_CIPHER_SPEC", this.properties.getSslCipherSpec());
            }
            if (!this.isNullOrEmpty(this.properties.getSslPeerName())) {
                cf.setStringProperty("XMSC_WMQ_SSL_PEER_NAME", this.properties.getSslPeerName());
            }
            cf.setBooleanProperty("XMSC_WMQ_SSL_FIPS_REQUIRED", this.properties.isSslFIPSRequired());
            Integer vi = this.properties.getSslKeyResetCount();
            if (vi != -1) {
                cf.setIntProperty("XMSC_WMQ_SSL_KEY_RESETCOUNT", vi.intValue());
            }
            if (!this.isNullOrEmpty(this.properties.getTempQPrefix())) {
                cf.setStringProperty("XMSC_WMQ_TEMP_Q_PREFIX", this.properties.getTempQPrefix());
            }
            if (!this.isNullOrEmpty(this.properties.getTempTopicPrefix())) {
                cf.setStringProperty("XMSC_WMQ_TEMP_TOPIC_PREFIX", this.properties.getTempTopicPrefix());
            }
            if (!this.isNullOrEmpty(this.properties.getTempModel())) {
                cf.setStringProperty("XMSC_WMQ_TEMPORARY_MODEL", this.properties.getTempModel());
            }
            Map<String, String> additionalProperties = this.properties.getAdditionalProperties();
            for (String k : additionalProperties.keySet()) {
                String v = additionalProperties.get(k);
                Boolean vb = null;
                vi = null;
                try {
                    vi = Integer.valueOf(v);
                    cf.setIntProperty(k, vi.intValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (vi == null && (v.toUpperCase().equals("TRUE") || v.toUpperCase().equals("FALSE"))) {
                    vb = Boolean.valueOf(v);
                    cf.setBooleanProperty(k, vb.booleanValue());
                }
                if (vi != null || vb != null) continue;
                cf.setStringProperty(k, v);
            }
            this.customize((MQConnectionFactory)cf);
            return cf;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | JMSException ex) {
            throw new IllegalStateException("Unable to create MQConnectionFactory" + (err != null ? ": " + err : ""), ex);
        }
    }

    private <T extends MQConnectionFactory> T createConnectionFactoryInstance(Class<T> factoryClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return (T)((MQConnectionFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    private void customize(MQConnectionFactory connectionFactory) {
        for (MQConnectionFactoryCustomizer factoryCustomizer : this.factoryCustomizers) {
            factoryCustomizer.customize(connectionFactory);
        }
    }

    boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

