/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobilefirstplatform.serversdk.java.push;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.mobilefirstplatform.serversdk.java.push.Notification;
import com.ibm.mobilefirstplatform.serversdk.java.push.PushMessageModel;
import com.ibm.mobilefirstplatform.serversdk.java.push.PushNotificationsResponseListener;
import com.ibm.mobilefirstplatform.serversdk.java.push.exception.PushServerSDKException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushNotifications {
    public static final String US_SOUTH_REGION = ".ng.bluemix.net";
    public static final String UK_REGION = ".eu-gb.bluemix.net";
    public static final String SYDNEY_REGION = ".au-syd.bluemix.net";
    public static final String FRANKFURT_REGION = ".eu-de.bluemix.net";
    public static final String US_EAST_REGION = ".us-east.bluemix.net";
    public static final Logger logger = Logger.getLogger(PushNotifications.class.getName());
    protected static String secret;
    protected static String apiKeyIdIs;
    protected static long apiKeyExpireyTime;
    protected static String accessToken;
    protected static String iamRegion;
    protected static String pushMessageEndpointURL;
    private static PushNotificationsResponseListener pushListner;
    public static String overrideServerHost;

    public static void init(String tenantId, String pushSecret, String bluemixRegion) {
        secret = pushSecret;
        PushNotifications.createPushEndPointUrl(tenantId, bluemixRegion);
    }

    private static void createPushEndPointUrl(String tenantId, String bluemixRegion) {
        pushMessageEndpointURL = overrideServerHost != null ? overrideServerHost + ":/imfpush/v1/apps/" + tenantId + "/messages" : "https://imfpush" + bluemixRegion + ":/imfpush/v1/apps/" + tenantId + "/messages";
    }

    public static void init(String bluemixRegion) {
        String tenantId = null;
        String pushSecret = null;
        tenantId = PushNotifications.getApplicationIdFromVCAP();
        pushSecret = PushNotifications.getPushSecretFromVCAP();
        if (tenantId == null || pushSecret == null) {
            PushServerSDKException exception = new PushServerSDKException("FPSDK0001A: PushNotifications could not be initialized. Credentials could not be found in environment variables. Make sure they are available, or use the other constructor.");
            logger.log(Level.SEVERE, exception.toString(), exception);
            throw exception;
        }
        PushNotifications.init(tenantId, pushSecret, bluemixRegion);
    }

    public static void initWithApiKey(String tenantId, String apiKeyId, String bluemixRegionn) {
        String tenantIdIs = tenantId;
        apiKeyIdIs = apiKeyId;
        if (tenantIdIs == null) {
            tenantIdIs = PushNotifications.getApplicationIdFromVCAP();
        }
        if (apiKeyIdIs == null) {
            apiKeyIdIs = PushNotifications.getPushApiKeyFromVCAP();
        }
        if (tenantId == null || apiKeyId == null) {
            PushServerSDKException exception = new PushServerSDKException("FPSDK0001A: PushNotifications could not be initialized. Credentials could not be found in environment variables. Make sure they are available, or use the other constructor.");
            logger.log(Level.SEVERE, exception.toString(), exception);
            throw exception;
        }
        PushNotifications.createPushEndPointUrl(tenantId, bluemixRegionn);
        iamRegion = bluemixRegionn;
    }

    public static CloseableHttpResponse getAuthToken() {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String iamUri = "https://iam" + iamRegion + "/identity/token";
        HttpPost pushPost = new HttpPost(iamUri);
        pushPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("grant_type", "urn:ibm:params:oauth:grant-type:apikey"));
        nvps.add(new BasicNameValuePair("apikey", apiKeyIdIs));
        try {
            pushPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            return httpClient.execute((HttpUriRequest)pushPost);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            throw new PushServerSDKException("FPSDK0004A: Error in fetching service access token", e);
        }
    }

    protected static String getApplicationIdFromVCAP() {
        JSONObject imfPushCredentials;
        JSONObject vcapServices;
        String vcapServicesAsString = PushNotifications.getEnvironmentVariable("VCAP_SERVICES");
        if (vcapServicesAsString != null && (vcapServices = new JSONObject(vcapServicesAsString)).has("imfpush") && (imfPushCredentials = vcapServices.getJSONArray("imfpush").optJSONObject(0).optJSONObject("credentials")) != null) {
            return imfPushCredentials.optString("appGuid");
        }
        return null;
    }

    protected static String getEnvironmentVariable(String name) {
        return System.getenv(name);
    }

    protected static String getPushSecretFromVCAP() {
        JSONObject imfPushCredentials;
        JSONObject vcapServices;
        String vcapServicesAsString = PushNotifications.getEnvironmentVariable("VCAP_SERVICES");
        if (vcapServicesAsString != null && (vcapServices = new JSONObject(vcapServicesAsString)).has("imfpush") && (imfPushCredentials = vcapServices.getJSONArray("imfpush").optJSONObject(0).optJSONObject("credentials")) != null) {
            return imfPushCredentials.optString("appSecret");
        }
        return null;
    }

    protected static String getPushApiKeyFromVCAP() {
        JSONObject imfPushCredentials;
        JSONObject vcapServices;
        String vcapServicesAsString = PushNotifications.getEnvironmentVariable("VCAP_SERVICES");
        if (vcapServicesAsString != null && (vcapServices = new JSONObject(vcapServicesAsString)).has("imfpush") && (imfPushCredentials = vcapServices.getJSONArray("imfpush").optJSONObject(0).optJSONObject("credentials")) != null) {
            return imfPushCredentials.optString("apiKey");
        }
        return null;
    }

    public static void send(Notification notification, PushNotificationsResponseListener listener) {
        pushListner = listener;
        if (pushMessageEndpointURL == null || pushMessageEndpointURL.length() == 0) {
            RuntimeException exception = new RuntimeException("FPSDK0003A: Cannot send a null push notification.");
            logger.log(Level.SEVERE, exception.toString(), exception);
            if (listener != null) {
                listener.onFailure(null, null, exception);
            }
            return;
        }
        if (notification == null) {
            IllegalArgumentException exception = new IllegalArgumentException("FPSDK0003A: Cannot send a null push notification.");
            logger.log(Level.SEVERE, exception.toString(), exception);
            if (listener != null) {
                listener.onFailure(null, null, exception);
            }
            return;
        }
        CloseableHttpClient httpClient = PushNotifications.enableTLS();
        PushMessageModel model = new PushMessageModel.Builder().message(notification.getMessage()).target(notification.getTarget()).settings(notification.getSettings()).build();
        JSONObject notificationJson = PushNotifications.generateJSON(model);
        HttpPost pushPost = null;
        pushPost = PushNotifications.createPushPostRequest(notificationJson);
        PushNotifications.executePushPostRequest(pushPost, httpClient, listener);
    }

    public static void sendBulk(Notification[] notifications, PushNotificationsResponseListener listener) {
        pushListner = listener;
        if (pushMessageEndpointURL == null || pushMessageEndpointURL.length() == 0) {
            RuntimeException exception = new RuntimeException("FPSDK0002A: PushNotifications has not been properly initialized.");
            logger.log(Level.SEVERE, exception.toString(), exception);
            if (listener != null) {
                listener.onFailure(null, null, exception);
            }
            return;
        }
        if (notifications.length == 0) {
            IllegalArgumentException exception = new IllegalArgumentException("FPSDK0003A: Cannot send a null push notification.");
            logger.log(Level.SEVERE, exception.toString(), exception);
            if (listener != null) {
                listener.onFailure(null, null, exception);
            }
            return;
        }
        CloseableHttpClient httpClient = PushNotifications.enableTLS();
        ArrayList<JSONObject> MessageJson = new ArrayList<JSONObject>();
        for (Notification notification : notifications) {
            PushMessageModel model = new PushMessageModel.Builder().message(notification.getMessage()).target(notification.getTarget()).settings(notification.getSettings()).build();
            JSONObject notificationJson = PushNotifications.generateJSON(model);
            MessageJson.add(notificationJson);
        }
        HttpPost pushPost = PushNotifications.createBulkPushPostRequest(MessageJson);
        PushNotifications.executePushPostRequest(pushPost, httpClient, listener);
    }

    private static CloseableHttpClient enableTLS() {
        CloseableHttpClient httpClient = null;
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, null);
            httpClient = HttpClients.custom().setSSLContext(sslContext).build();
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, e.toString(), e);
        }
        catch (KeyManagementException e) {
            logger.log(Level.SEVERE, e.toString(), e);
        }
        return httpClient;
    }

    private static JSONObject generateJSON(Object obj) {
        JSONObject settingsJson;
        JSONObject json;
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = null;
        try {
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            jsonString = mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException exception) {
            logger.log(Level.SEVERE, exception.toString(), exception);
        }
        JSONObject jSONObject = json = jsonString != null ? new JSONObject(jsonString) : new JSONObject();
        if (json.has("settings") && (settingsJson = json.getJSONObject("settings")).has("fcm")) {
            settingsJson.put("gcm", (Object)settingsJson.getJSONObject("fcm"));
            settingsJson.remove("fcm");
        }
        return json;
    }

    protected static HttpPost createPushPostRequest(JSONObject notification) {
        HttpPost pushPost = new HttpPost(pushMessageEndpointURL);
        pushPost.addHeader("Content-Type", "application/json");
        PushNotifications.setHeader(pushPost);
        StringEntity body = new StringEntity(notification.toString(), "UTF-8");
        pushPost.setEntity((HttpEntity)body);
        return pushPost;
    }

    protected static HttpPost createBulkPushPostRequest(List<JSONObject> messageJson) {
        HttpPost pushPost = new HttpPost(pushMessageEndpointURL + "/bulk");
        pushPost.addHeader("Content-Type", "application/json");
        PushNotifications.setHeader(pushPost);
        StringEntity body = new StringEntity(messageJson.toString(), "UTF-8");
        pushPost.setEntity((HttpEntity)body);
        return pushPost;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void setHeader(HttpPost pushPost) {
        if (secret != null) {
            pushPost.addHeader("appSecret", secret);
            return;
        }
        CloseableHttpResponse auth = null;
        try {
            if (accessToken == null || apiKeyExpireyTime - System.currentTimeMillis() / 1000L < 0L) {
                auth = PushNotifications.getAuthToken();
                JSONObject json = null;
                json = new JSONObject(EntityUtils.toString((HttpEntity)auth.getEntity()));
                int statusCode = auth.getStatusLine().getStatusCode();
                String resonPhrase = auth.getStatusLine().getReasonPhrase();
                if (statusCode == 200) {
                    accessToken = json.getString("access_token");
                    apiKeyExpireyTime = json.getInt("expiration");
                    pushPost.addHeader("Authorization", "Bearer " + accessToken);
                    return;
                }
                PushServerSDKException pushServerSDKException = new PushServerSDKException(resonPhrase);
                if (pushListner == null) throw pushServerSDKException;
                pushListner.onFailure(statusCode, pushServerSDKException.getLocalizedMessage(), pushServerSDKException);
                throw pushServerSDKException;
            }
            pushPost.addHeader("Authorization", "Bearer " + accessToken);
            return;
        }
        catch (ParseException e) {
            throw new PushServerSDKException("FPSDK0006A:  Header elements cannot be parsed", e);
        }
        catch (IOException e) {
            throw new PushServerSDKException("FPSDK0007A: An error occurs reading the input stream", e);
        }
        finally {
            if (auth != null) {
                try {
                    auth.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void executePushPostRequest(HttpPost pushPost, CloseableHttpClient httpClient, PushNotificationsResponseListener listener) {
        block19: {
            CloseableHttpResponse response = null;
            try {
                if (httpClient != null && listener != null) {
                    response = httpClient.execute((HttpUriRequest)pushPost);
                    PushNotifications.sendResponseToListener(response, listener);
                    break block19;
                }
                throw new PushServerSDKException("FPSDK0002A: PushNotifications has not been properly initialized.");
            }
            catch (ClientProtocolException e) {
                logger.log(Level.SEVERE, e.toString(), e);
                if (listener != null) {
                    listener.onFailure(null, null, e);
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.toString(), e);
                if (listener != null) {
                    listener.onFailure(null, null, e);
                }
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    protected static void sendResponseToListener(CloseableHttpResponse response, PushNotificationsResponseListener listener) throws IOException {
        String responseBody = null;
        if (response.getEntity() != null) {
            ByteArrayOutputStream outputAsByteArray = new ByteArrayOutputStream();
            response.getEntity().writeTo((OutputStream)outputAsByteArray);
            responseBody = new String(outputAsByteArray.toByteArray());
        }
        Integer statusCode = null;
        if (response.getStatusLine() != null) {
            statusCode = response.getStatusLine().getStatusCode();
        }
        if (statusCode != null && statusCode == 202) {
            listener.onSuccess(statusCode, responseBody);
        } else {
            if (statusCode != null && statusCode == 401) {
                accessToken = null;
                logger.log(Level.SEVERE, response.getStatusLine().getReasonPhrase());
            }
            listener.onFailure(statusCode, responseBody, null);
        }
    }

    static {
        overrideServerHost = null;
    }
}

