/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public class JsonMergeUtils
implements Serializable {
    private static final long serialVersionUID = 6579954130589053721L;

    public static JsonNode merge(JsonNode x, JsonNode y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (x.isObject() && y.isObject()) {
            return JsonMergeUtils.merge((ObjectNode)x, (ObjectNode)y);
        }
        if (x.isArray() && y.isArray()) {
            return JsonMergeUtils.merge((ArrayNode)x, (ArrayNode)y);
        }
        return x;
    }

    private static ObjectNode merge(ObjectNode x, ObjectNode y) {
        Iterator<Map.Entry<String, JsonNode>> yit = y.fields();
        while (yit.hasNext()) {
            Map.Entry<String, JsonNode> ye = yit.next();
            String f = ye.getKey();
            JsonNode yv = ye.getValue();
            JsonNode xv = x.get(f);
            x.set(f, JsonMergeUtils.merge(xv, yv));
        }
        return x;
    }

    private static ArrayNode merge(ArrayNode x, ArrayNode y) {
        ArrayNode output = JsonNodeFactory.instance.arrayNode();
        for (int i = 0; i < x.size() || i < y.size(); ++i) {
            JsonNode xv = i < x.size() ? x.get(i) : null;
            JsonNode yv = i < y.size() ? y.get(i) : null;
            output.add(JsonMergeUtils.merge(xv, yv));
        }
        return output;
    }
}

