/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.JSONataUtils;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.UnsupportedEncodingException;

public class URLDecodeComponentFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$decodeUrlComponent");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$decodeUrlComponent");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$decodeUrlComponent");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        JsonNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = URLDecodeComponentFunction.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            if (argString != null && !argString.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 1) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        if (!useContext) {
            argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argString == null) {
            return null;
        }
        if (!argString.isTextual()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        String str = argString.textValue();
        int testChar = 32;
        for (int i = 0; i < str.length(); ++i) {
            testChar = str.charAt(i);
            if (testChar <= 255) continue;
            String hexChars = Integer.toHexString(testChar).toUpperCase();
            String unicode = "\\u" + hexChars;
            throw new EvaluateRuntimeException("Malformed URL passed to $decodeUrlComponent: \"" + unicode + "\"");
        }
        try {
            return new TextNode(JSONataUtils.decodeURIComponent(str));
        }
        catch (UnsupportedEncodingException e) {
            throw new EvaluateRuntimeException("Malformed URL passed to $decodeUrlComponent: \"" + str + "\"");
        }
        catch (IllegalArgumentException iae) {
            throw new EvaluateRuntimeException("Malformed URL passed to $decodeUrlComponent: \"" + str + "\"");
        }
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<s-:n>";
    }
}

